//************************************************************************************//
// Module       : gbasislist.cpp
// Date         : 7/26/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple object template linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast as a template
//                class for basis objects.
// Derived From : GTBasisList.
// Modifications:
//************************************************************************************//
#include "gtbasislist.hpp"


//************************************************************************************
//************************************************************************************
// Constructor Method
template<class TT> GTBasisList<TT>::GTBasisList<TT>(GBOOL renumber_on_delete)
: GObjList<TT>(renumber_on_delete)
{
} // end of constructor method


//************************************************************************************
//************************************************************************************
// Destructor
template<class TT> GTBasisList<TT>::~GTBasisList<TT>()
{
  empty();
}


//************************************************************************************
//************************************************************************************
// METHOD     : add 
// DESCRIPTION: 
// RETURNS    : add new structure to list
//************************************************************************************
template<class TT> void GTBasisList<TT>::add(GINT iorder)
{
  pCurr        = pEnd;
  pEnd         = new ObjLinkElem;
  pEnd->member = new TT (iorder) ;
  pEnd->id     = nid;
  pEnd->cf     = TRUE;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (1)

//************************************************************************************
//************************************************************************************
// METHOD     : findorder (1)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> GBOOL GTBasisList<TT>::findorder(GINT  iorder)
{
  ObjLinkElem *p;

  // start at beginning and search:
  start();
  while ( (p=curr()) != NULL ) {
    if ( p->member->GetOrder() == iorder ) return TRUE;
    next();
  }
  return FALSE;
  
} // end of method findorder (1)


//************************************************************************************
//************************************************************************************
// METHOD     : findorder (2)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> GBOOL GTBasisList<TT>::findorder(GINT  iorder, GINT &ind)
{
  ObjLinkElem *p;

  // start at beginning and search:
  start();
  while ( (p=curr()) != NULL ) {
    if ( p->member->GetOrder() == iorder ) {
      ind = p->id;
      return TRUE;
    }
    next();
  }
  return FALSE;
  
} // end of method findorder (2)
