//************************************************************************************//
// Module       : gbasislist.cpp
// Date         : 7/26/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple object template linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast as a template
//                class for basis objects.
// Derived From : GTBasisList.
// Modifications:
//************************************************************************************//
#if !defined(GTBASISLIST_HPP)
#define GTBASISLIST_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "gobjlist.hpp"
#include "gllbasis.hpp"
#include "glbasis.hpp"

#if !defined(GTBasisListGLL)
#  define GTBasisListGLL GTBasisList<GLLBasis>
#endif

#if !defined(GTBasisListGL)
#  define GTBasisListGL GTBasisList<GLBasis>
#endif


template <class TT> class GTBasisList : public GObjList<TT>
{

public:
                          GTBasisList(GBOOL renumber_on_delete=FALSE);
                          GTBasisList(GINT  nelems, GBOOL renumber_on_delete=FALSE);
                          GTBasisList(const GTBasisList &);
                         ~GTBasisList();

         void             add(GINT order);
         GBOOL            findorder(GINT order);
         GBOOL            findorder(GINT order, GINT &ind);
         
private:
// Private methods:

// Private data:

};
#  if defined(_LINUX) || defined(_AIX)
template class GTBasisList<GLLBasis>;
template class GTBasisList<GLBasis>;
# endif
#endif

