//************************************************************************************
// Module       : gtlist.hpp
// Date         : 8/9/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple template linked list. This is intended to form 
//                the basic core of all single template argument lists.
//                This class was taken largely from Algorithms and Data 
//                Structures in C++ by Ameraal, although it has been recast 
//                as a template class.
// Derived From : none.
// Modifications:
//************************************************************************************
#if !defined(GTLIST_HPP)
#define GTLIST_HPP

#include <iostream.h>
#include <string>
#include "gtypes.h"
#include <stdlib.h>
#include "vdbdata.hpp"
#include "gneighbor.hpp"
#include "point.hpp"

#if !defined(GStringList)
#  define GStringList GTList<string>
#endif

#if !defined(VDBList)
#  define VDBList GTList<VDBData>
#endif

#if !defined(GNeighborList)
#  define GNeighborList GTList<GNeighbor>
#endif

#if !defined(GPointList)
#  define GPointList GTList<Point>
#endif

#if !defined(GFList)
#  define GFList GTList<GDOUBLE>
#endif

#if !defined(GIList)
#  define GIList GTList<GINT >
#endif

#if !defined(GCList)
#  define GCList GTList<char>
#endif

#if !defined(GpCList)
#  define GpCList GTList<char*>
#endif



#if !defined(TBASICLINKELEM)
#define BASICLINKELEMT
#define TBasicLinkElem BasicLinkElemT<TT>
template<class TT> class BasicLinkElemT {
public:
GINT           id;
GBOOL          cf;
TT             *member;
TBasicLinkElem *next;
TBasicLinkElem *prev;
};
#endif


template <class TT> class GTList
{

public:
                          GTList(GBOOL renumber_on_delete=FALSE);
                          GTList(GINT  nelems, GBOOL renumber_on_delete=FALSE);
                          GTList(const GTList &);
                         ~GTList();

         friend ostream&  operator<<(ostream&, GTList<TT>&);
         void             add();
         void             add(TT *c, GBOOL delete_here=FALSE);
         TT               *del(TBasicLinkElem *e);
         TT               *del(TT *c);
         TT               *del(GINT  id);
inline   void             start(TBasicLinkElem *p=NULL) {
           pCurr = ( p!=NULL ? p : pStart );
         }
         GINT             size() ;
inline   TT               *member() {
           return pCurr ? pCurr->member : NULL;
         }
inline   TT               *member(GINT  id) {
           TBasicLinkElem *e;
           if ( (e=find(id)) == NULL ) return NULL;
           return e->member;
         }
inline   TBasicLinkElem   *next() {
           TBasicLinkElem *p = pCurr ? pCurr->next : NULL;
           pCurr = p;
           return pCurr;
         }
         TBasicLinkElem   *curr();
inline   TBasicLinkElem   *find(GINT  id){ TBasicLinkElem *p=pCurr;
         if ( p && p->id == id ) return p;
         else if ( p && p->next && p->next->id == id ) {
         next(); return p->next; }

         start(NULL);
         while ( (p=curr()) != NULL ) {
         if ( p->id == id ) return p; next(); }
          return NULL; }
inline   TBasicLinkElem        *find(TT *c) { TBasicLinkElem *p=pCurr;
         if ( p && p->member == c ) return p;
         else if ( p && p->next && p->next->member == c ) {
         next(); return p->next; }
  
         start(NULL);
         while ( (p=curr()) != NULL ) {
         if ( p->member == c ) return p; next(); }
         return NULL; }
inline   TT               &operator()(const GINT ielem) {
           TBasicLinkElem *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(ielem);
#else
           if ( (tt=find(ielem)) == NULL || tt->member == NULL ) {
             cout << "GTList::operator(): Cannot access element " << ielem << endl;
             exit(1);
           }
#endif
           return *(tt->member);
         }
inline   TT               &operator[](const GINT ielem) {
           TBasicLinkElem *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(ielem);
#else
           if ( (tt=find(ielem)) == NULL || tt->member == NULL ) {
             cout << "GTList::operator[]: Cannot access element " << ielem << endl;
             exit(1);
           }
#endif
           return *(tt->member);
         }
         GBOOL            renumber();
         void             empty();
//       GBOOL            inlist(GSHORT  iproc, GINT  ielem);


private:
// Private methods:



// Private data:
        GINT                   nid;
        GINT                   num;
        GBOOL                  doRenumber;
        TBasicLinkElem         *pStart;
        TBasicLinkElem         *pCurr;
        TBasicLinkElem         *pEnd;

};
#  if defined(_LINUX) || defined(_AIX)
template class GTList<string>;
ostream &operator <<(ostream&, GTList<string>&);
template class GTList<GDOUBLE>;
ostream &operator <<(ostream&, GTList<GDOUBLE>&);
template class GTList<GINT>;
ostream &operator <<(ostream&, GTList<GINT>&);
template class GTList<char>;
ostream &operator <<(ostream&, GTList<char>&);
template class GTList<char*>;
ostream &operator <<(ostream&, GTList<char*>&);
template class GTList<VDBData>;
ostream &operator <<(ostream&, GTList<VDBData>&);
template class GTList<GNeighbor>;
ostream &operator <<(ostream&, GTList<GNeighbor>&);
template class GTList<Point>;
ostream &operator <<(ostream&, GTList<Point>&);
# endif
#endif
