//************************************************************************************//
// Module       : gtlistarray.cpp
// Date         : 4/19/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple template linked list of linked lists. 
// Derived From : none. 
// Modifications:
//************************************************************************************//
#include "gtlistarray.hpp"

//************************************************************************************
//************************************************************************************
// Constructor Method
template<class TT> GTListArray<TT>::GTListArray<TT>(GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{

} // end of constructor method


//************************************************************************************
//************************************************************************************
// Constructor Method (2)
template<class TT> GTListArray<TT>::GTListArray<TT>(GINT  nelems, GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{   
  GINT  i;

  for ( i=0; i<nelems; i++ ) {
    add(NULL,TRUE);
  }
    
} // end of constructor method (2)


//************************************************************************************
//************************************************************************************
// Destructor
template<class TT> GTListArray<TT>::~GTListArray<TT>()
{
  empty();
}

//************************************************************************************
//************************************************************************************
// METHOD     : add (1)
// DESCRIPTION: 
// RETURNS    : add new structure to list
//************************************************************************************
template<class TT> void GTListArray<TT>::add()
{
  pCurr        = pEnd;
  pEnd         = new TListArrayElem;
  pEnd->member = new TT () ;
  pEnd->id     = nid;
  pEnd->cf     = TRUE;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (1)


//************************************************************************************
//************************************************************************************
// METHOD     : add (2)
// DESCRIPTION: 
// RETURNS    : add new structure to list
//************************************************************************************
template<class TT> void GTListArray<TT>::add(TT *m, GBOOL del_here)
{
  pCurr        = pEnd;
  pEnd         = new TListArrayElem;
  pEnd->member = m ;
  pEnd->id     = nid;
  pEnd->cf     = del_here;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (2)


//************************************************************************************
// METHOD     : del (0)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
template<class TT> TT *GTListArray<TT>::del(TListArrayElem *e)
{
  TListArrayElem *next, *prev;
  TT        *m;

  if ( e == NULL ) {
    cout << "template<class TT> TT *GTListArray<TT>::del (0) : attempting to delete a NULL list element" << endl;
    exit(1);
  }

  m    = e->member;
  prev = e->prev;
  next = e->next;

  if ( prev ) prev->next = next;
  if ( next ) next->prev = prev;

  if ( e->cf ) delete e->member;
  delete e;

//(pCurr ? pCurr->next : pStart) = pEnd;
//if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pEnd   == e )  pEnd   = prev;
  pCurr = next ? next : prev;
  if ( pStart == e )  pStart = next ? next : pCurr;

  num--;

  if ( doRenumber ) renumber();

  return m;

} // end of method del (0)


//************************************************************************************
//************************************************************************************
// METHOD     : del (1)
// DESCRIPTION:
// RETURNS    : delete structure from list. Do a renumbering of ids if 
//              set to do so on construction.
//************************************************************************************
template<class TT> TT *GTListArray<TT>::del(TT *m)
{
  TListArrayElem *e;

  if ( !(e=find(m)) ) return NULL;

  return del(e);
  
} // end of method del (1)


//************************************************************************************
//************************************************************************************
// METHOD     : del (2)
// DESCRIPTION:
// RETURNS    : delete structure from list. Do a renumbering of ids if
//              set to do so on construction.
//************************************************************************************
template<class TT> TT *GTListArray<TT>::del(GINT  id)
{ 
  TListArrayElem *e;
  
  if ( !(e=find(id)) ) return NULL;

  return del(e);
 
} // end of method del (2)


//************************************************************************************
//************************************************************************************
// METHOD     : size
// DESCRIPTION:
// RETURNS    :  size of list
//************************************************************************************
template<class TT> GINT  GTListArray<TT>::size() 
{
  return num ;
} // end of method size


//************************************************************************************
//************************************************************************************
// METHOD     : start
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> void GTListArray<TT>::start(TListArrayElem *p)
{
  pCurr = ( p!=NULL ? p : pStart );
} // end of method start


//************************************************************************************
//************************************************************************************
// METHOD     : member (1)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> TT *GTListArray<TT>::member()
{
  return pCurr ? pCurr->member : NULL;
} // end of method member (1)


//************************************************************************************
//************************************************************************************
// METHOD     : member (2)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> TT *GTListArray<TT>::member(GINT id)
{
  TListArrayElem *e;

  if ( (e=find(id)) == NULL ) return NULL;

  return e->member;
} // end of method member (2)


//************************************************************************************
//************************************************************************************
// METHOD     : next
// DESCRIPTION: 
// RETURNS    :  
//************************************************************************************
template<class TT> TListArrayElem *GTListArray<TT>::next()
{
  TListArrayElem *p = pCurr ? pCurr->next : NULL;
  pCurr = p;
  return pCurr;
} // end of method next


//************************************************************************************
//************************************************************************************
// METHOD     : curr
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> TListArrayElem *GTListArray<TT>::curr()
{
  return pCurr;
} // end of method curr


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : find (1)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
template<class TT> TListArrayElem *GTListArray<TT>::find(GINT  id)
{

  TListArrayElem *p=pCurr;

  // check from current pointer first:
  if ( p && p->id == id ) return p;
  else if ( p && p->next && p->next->id == id ) {
    next();
    return p->next;
  }

  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL )
  {
    if ( p->id == id ) return p;
    next();
  }
  return NULL;

} // end of method find (1)


//************************************************************************************
//************************************************************************************
// METHOD     : find (2)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
template<class TT> TListArrayElem *GTListArray<TT>::find(TT *member)
{

  TListArrayElem *p=pCurr;

  // check from current pointer first:
  if ( p && p->member == member ) return p;
  else if ( p && p->next && p->next->member == member ) {
     next();
     return p->next;
  }

  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL )
  {
    if ( p->member == member ) return p;
    next();
  }
  return NULL;

} // end of method find (2)
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : operator()
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
template<class TT> TT &GTListArray<TT>::operator()(const GINT iElem)
{
  TListArrayElem *tt;

#if !defined(GLIST_BOUNDS)
  tt=find(iElem);
#else
  if ( (tt=find(iElem)) == NULL || tt->member == NULL )
  {
    cout << "GTListArray::operator(): Cannot access element " << iElem << endl;
    exit(1);
  }
#endif

  return *(tt->member);
 
} // end of method operator ()


//************************************************************************************
//************************************************************************************
// METHOD     : operator[]
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
template<class TT> TT &GTListArray<TT>::operator[](const GINT iElem)
{
  TListArrayElem *tt;

#if !defined(GLIST_BOUNDS)
  tt=find(iElem);
#else
  if ( (tt=find(iElem)) == NULL || tt->member == NULL )
  {
    cout << "GTListArray::operator[]: Cannot access element " << iElem << endl;
    exit(1);
  }
#endif

  return *(tt->member);

} // end of method operator[]


//************************************************************************************
//************************************************************************************
// METHOD     : renumber
// DESCRIPTION:
// RETURNS    : Renumber ids consecutively, used mainly after a delete
//************************************************************************************
template<class TT> GBOOL GTListArray<TT>::renumber()
{
  GINT      i=0;
  TListArrayElem *p;
//TListArrayElem *pkeep=curr();

  start(NULL);
  while ( (p=curr()) != NULL )
  {
    p->id = i;
    next();
    i++;
  }
  nid = i;
  start(NULL);
  return TRUE;
} // end of method renumber



//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (1)
// DESCRIPTION:
// ARGUMENTS  :
//
// RETURNS    :  
//************************************************************************************
template<class TT> ostream &operator<<(ostream &str, GTListArray<TT> &a)
{

  GINT  i=0;  

  str << endl;
  a.start(NULL);
  while ( a.member() && i < a.size() )
  {
    str << "member[" << i << "]=" << *(a.member()) << endl;
    a.next();
    i++;
  }
  a.start(NULL);
    
  return str;
} // end of << operator(1)


//************************************************************************************
//************************************************************************************
// METHOD     : empty
// DESCRIPTION:
// RETURNS    : delete list data
//************************************************************************************
template<class TT> void GTListArray<TT>::empty()
{
  TListArrayElem *dcurr, *dnext;
  
  dcurr = pStart;
  while ( dcurr )
  {
    dnext = dcurr->next;
    del (dcurr);
    dcurr = dnext;
  }
  pStart = pEnd = pCurr = NULL;
  num = nid = 0;

} // end of method empty


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : inlist
// DESCRIPTION:
// RETURNS    : determine if proc and elemid are in GNeighborList
//************************************************************************************
template<class GNeighbor> GBOOL GTListArray<GNeighbor>::inlist(GSHORT  iproc, GINT  ielem)
{
  GBOOL     bfound=FALSE;
  TListArrayElem *p, *pkeep=curr();

  start(NULL);
  while ( (p=curr()) != NULL && !bfound )
  { 
    bfound = ( p->member->proc() == iproc && p->member->elemid() == ielem);
    next();
  }
  start(pkeep);
  return bfound;
} // end of method inlist
#endif

