//************************************************************************************
// Module       : gtlistarray.hpp
// Date         : 4/19/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple template linked list of linked lists. 
// Derived From : none.
// Modifications:
//************************************************************************************
#if !defined(GTLISTARRAY_HPP)
#define GTLISTARRAY_HPP

#include <iostream.h>
#include <string>
#include <stdlib.h>
#include "gtypes.h"
#include "gelemlist.hpp"
#include "gfieldlist.hpp"
#include "gneighbor.hpp"

#if !defined(GFieldListArray)
#  define GFieldListArray GTListArray<GFieldList>
#endif

#if !defined(GElemListArray)
#  define GElemListArray GTListArray<GElemList>
#endif

#if !defined(LISTARRAYELEM_T)
#define LISTARRAYELEM_T
#define TListArrayElem ListArrayElemT<TT>
template<class TT> class ListArrayElemT {
public:
GINT           id;
GBOOL          cf;
TT             *member;
TListArrayElem *next;
TListArrayElem *prev;
};
#endif

template <class TT> class GTListArray
{

public:
                          GTListArray(GBOOL renumber_on_delete=FALSE);
                          GTListArray(GINT  nelems, GBOOL renumber_on_delete=FALSE);
                          GTListArray(const GTListArray &);
                         ~GTListArray();

         friend ostream&  operator<<(ostream&, GTListArray<TT>&);
         void             add();
         void             add(TT *c, GBOOL delete_here=FALSE);
         TT               *del(TListArrayElem *e);
         TT               *del(TT *c);
         TT               *del(GINT  id);
         void             start(TListArrayElem *p=NULL);
         GINT             size() ;
         TT               *member();
         TT               *member(GINT  id);
         TListArrayElem   *next();
         TListArrayElem   *curr();
inline   TListArrayElem   *find(GINT  id){ TListArrayElem *p=pCurr;
         if ( p && p->id == id ) return p;
         else if ( p && p->next && p->next->id == id ) {
         next(); return p->next; }

         start(NULL);
         while ( (p=curr()) != NULL ) {
         if ( p->id == id ) return p; next(); }
          return NULL; }
inline   TListArrayElem  *find(TT *c) { TListArrayElem *p=pCurr;
         if ( p && p->member == c ) return p;
         else if ( p && p->next && p->next->member == c ) {
         next(); return p->next; }
  
         start(NULL);
         while ( (p=curr()) != NULL ) {
         if ( p->member == c ) return p; next(); }
         return NULL; }
         TT               &operator()(const GINT iElem);
         TT               &operator[](const GINT iElem);
         GBOOL            renumber();
         void             empty();
//       GBOOL            inlist(GSHORT  iproc, GINT  ielem);


private:
// Private methods:



// Private data:
        GINT              nid;
        GINT              num;
        GBOOL             doRenumber;
        TListArrayElem    *pStart;
        TListArrayElem    *pCurr;
        TListArrayElem    *pEnd;

};
#  if defined(_LINUX) || defined(_AIX)
template class GTListArray<GFieldList>;
ostream &operator <<(ostream&, GTListArray<GFieldList>&);
template class GTListArray<GElemList>;
ostream &operator <<(ostream&, GTListArray<GElemList>&);
template class GTListArray<GNeighbor>;
ostream &operator <<(ostream&, GTListArray<GNeighbor>&);
# endif
#endif

