//************************************************************************************//
// Module       : gtmatbuffer.hpp
// Date         : 6/5/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a template matrix-buffer object, whose data is composed of
//                variable length buffers.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GTMATBUFFER_HPP)
#define GTMATBUFFER_HPP
#include <iostream.h>
#include <stdlib.h>
#include <memory.h>
#include <iomanip.h>
#include <iostream.h>
#include "gtypes.h"
#include "gtbuffer.hpp"


template<class T> class GTMatBuffer
{
public:
                          GTMatBuffer();
                          GTMatBuffer(const GINT , const GINT );
                          GTMatBuffer(T *array, GINT  n1, GINT  n2);
                          GTMatBuffer(const GTMatBuffer<T> &);

                         ~GTMatBuffer();

inline virtual  T         &operator()(const GINT  i, const GINT  j ){
#if defined(GARRAY_BOUNDS)

                          if ( i >= dim(1) || i < 0 || j >= dim(2) || j < 0  ) {
                            cout << "GTMatBuffer<T>::&(): access error"<< endl;
                            exit(1);
                            }
#endif
                          GBuffer<T> *v;
                          v = data[i];
                          return (*v)(j);}  //*(v->Data() + j - v->GetIndex().beg());}


inline  virtual  T        operator()(const GINT  i , const GINT  j ) const {
#if defined(GARRAY_BOUNDS)
                          if ( i >= dim(1) || i < 0 || j >= dim(2) || j < 0  ) {
                            cout << "GTMatBuffer<T>::&(): access error"<< endl;
                            exit(1);
                            }
#endif
                          GBuffer<T> *v;
                          v = data[i];
                          return (*v)(j);}   //*(v->Data() + j - v->GetIndex().beg());}
                   
virtual  GTMatBuffer<T>   operator=(const GTMatBuffer<T> &);
virtual  void             operator=(T m);
virtual  GINT             tsize(GINT  idir);  // _total_ size = n_idir + n_idir_pad_
virtual  GINT             dim(GINT  idir) const;

virtual  GBuffer<T>      **Data() const;
virtual  GBOOL            Resize(GINT  Nx, GINT  Ny);
  
         friend ostream&  operator<<(ostream &, GTMatBuffer<T> );

private:

// Private methods:
void              DeleteDynamic();


// Private data:
GINT              n1;
GINT              n2;
G_DATATYPE        dtype;

GBuffer<T>       **data;


};
# if defined(_LINUX) || defined(_AIX)
template class GTMatBuffer<GINT >;
#  endif
#endif
