//************************************************************************************//
// Module       : gttlist.hpp
// Date         : 8/9/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple template linked list of a template class.
//                This class was taken largely from Algorithms and Data Structures 
//                in C++ by Ameraal, although it has been recast as a template
//                class.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GTTLIST_HPP)
#define GTTLIST_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "gtbuffer.hpp"
#include "gtvector.hpp"


#if !defined(FBuffList)
#  define FBuffList GTTList<GDOUBLE,GBuffer>
#endif

#if !defined(IBuffList)
#  define IBuffList GTTList<GINT ,GBuffer>
#endif

#if !defined(BTBuffList)
#  define BTBuffList GTTList<BDYTYPE,GBuffer>
#endif

#if !defined(GVecList)
#  define GVecList GTTList<GDOUBLE,GTVector>
#endif


#if !defined(TTLINKELEM)
#define TTLINKELEM
#define TTLinkElem LinkElemTT<TL,TT>
template<class TL, template<class> class TT> class LinkElemTT {
public:
GINT       id;
GBOOL      cf;
TT<TL>     *member;
TTLinkElem *next;
TTLinkElem *prev;
}; 
#endif

template<class TL, template<class> class TT> class GTTList
{
public:
                          GTTList(GBOOL renumber_on_delete=FALSE);
                          GTTList(GINT  nelems, GBOOL renumber_on_delete=FALSE);
                          GTTList(const GTTList &){};
                         ~GTTList();

         void             operator=(TL a);
         void             operator=(GTTList<TL,TT> &v);
         void             add();
         void             add(TT<TL> *c, GBOOL delete_here);
         void             add(TL *c, GINT  n, GBOOL delete_here);
         TT<TL>           *del(TTLinkElem *e);
         TT<TL>           *del(TT<TL> *c);
         TT<TL>           *del(GINT  id);
inline   void             start(TTLinkElem *p=NULL) {
           pCurr = ( p!=NULL ? p : pStart );
         }
         GINT             size() ;
inline   TT<TL>           *member() {
           return pCurr ? pCurr->member : NULL;
         }
inline   TT<TL>           *member(GINT id) {
            TTLinkElem *e;
            if ( (e=find(id)) == NULL ) return NULL;
            return e->member;
         }
inline   TTLinkElem       *next() {
           TTLinkElem *p = pCurr ? pCurr->next : NULL;
           pCurr = p;
           return pCurr;
         }
         TTLinkElem       *curr();
         TTLinkElem       *find(GINT  id) {
           TTLinkElem *p=pCurr;
           // check from current pointer first:
           if ( p && p->id == id ) return p;
           else if ( p && p->next && p->next->id == id ) {
             next(); return p->next;
           }
           start(); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->id == id ) return p; next();
           }
           return NULL;
         }
         TTLinkElem       *find(TT<TL> *member) {
           TTLinkElem *p=pCurr;
           // check from current pointer first:
           if ( p && p->member == member ) return p;
           else if ( p && p->next && p->next->member == member ) {
              next(); return p->next;
           }
           start(); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->member == member ) return p; next();
           }
           return NULL;
         }
inline   TL               &operator()(const GINT iElem, const GINT i) {
           TT<TL> *tt;
#if !defined(GLIST_BOUNDS)
           tt=member(iElem);
#else
           if ( (tt=member(iElem)) == NULL ) {
             cout << "GTTList::operator(): Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return (*tt)(i) ;
         }
inline   TT<TL>           *&operator()(const GINT iElem) {
           TTLinkElem  *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GTTList::operator(): Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member;
         }
inline   TT<TL>           *&operator[](const GINT iElem) {
           TTLinkElem *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GTTList::operator[]: Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member;
         }
         GINT             dim(const GINT iElem);
         GBOOL            renumber();
         void             empty();
         friend ostream&  operator<<(ostream&, GTTList<GDOUBLE,GBuffer>&);
         friend ostream&  operator<<(ostream&, GTTList<GINT ,GBuffer>&);
         friend ostream&  operator<<(ostream&, GTTList<BDYTYPE,GBuffer>&);
         friend ostream&  operator<<(ostream&, GTTList<GDOUBLE  ,GTVector>&);
#if 0
         friend ostream&  operator<<(ostream&, GTTList<TL,TT>&);
#endif

private:
// Private methods:

// Private data:
        GINT              nid;
        GINT              num;
        GBOOL             doRenumber;
        TTLinkElem        *pStart;
        TTLinkElem        *pCurr;
        TTLinkElem        *pEnd;

};
#  if defined(_LINUX) || defined(_AIX)
template class GTTList<GDOUBLE,GBuffer>;
template class GTTList<GINT ,GBuffer>;
template class GTTList<BDYTYPE,GBuffer>;
template class GTTList<GDOUBLE,GTVector>;
ostream &operator <<(ostream&, GTTList<GDOUBLE,GBuffer>&);
ostream &operator <<(ostream&, GTTList<GINT ,GBuffer>&);
ostream &operator <<(ostream&, GTTList<BDYTYPE,GBuffer>&);
ostream &operator <<(ostream&, GTTList<GDOUBLE,GTVector>&);
# endif
#  if 0
GTTList<GDOUBLE,GBuffer>   __dec_SEFBList;
GTTList<GINT ,GBuffer>   __dec_SEIList;
GTTList<BDYTYPE,GBuffer> __dec_SEBTList;
GTTList<GDOUBLE,GTVector>   __dec_GVecList;
ostream &operator <<(ostream&, GTTList<GDOUBLE,GBuffer>&);
ostream &operator <<(ostream&, GTTList<GINT ,GBuffer>&);
ostream &operator <<(ostream&, GTTList<BDYTYPE,GBuffer>&);
ostream &operator <<(ostream&, GTTList<GDOUBLE,GTVector>&);
#  endif
#endif

