//************************************************************************************//
// Module       : siforcelist.cpp
// Date         : 5/9/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a linked list for state-independent (SIForce-based)
//                forces. It was taken largely from Algorithms and Data Structures
//                in C++ by Ameraal, although it has been modified significantly.
//
//                NOTE: it is clear that this class and the GFieldList template
//                can be derived from a common base class. The GElemList may also
//                be recast in this way, but there is some ambiguity because
//                the Elem is also a base class itself, and the syntax may
//                cause difficulty on some OS's.
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "siforcelist.hpp"
#include "evforce.hpp"


//************************************************************************************
//************************************************************************************
// Constructor Method
SIForceList::SIForceList()
:
nid                   (0),
num                   (0),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{

} // end of constructor method


//************************************************************************************
//************************************************************************************
// Destructor
SIForceList::~SIForceList()
{
  empty();
}

//************************************************************************************
//************************************************************************************
// METHOD     : add (1)
// DESCRIPTION: 
// RETURNS    : add new structure to list
//************************************************************************************
void SIForceList::add(SIForce *m, GBOOL delete_here)
{
  pCurr        = pEnd;
  pEnd         = new SIForceListSt;
  pEnd->member = m ;
  pEnd->id     = nid;
  pEnd->cf     = delete_here;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (1)


//************************************************************************************
//************************************************************************************
// METHOD     : del (0)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
SIForce *SIForceList::del(SIForceListSt *e)
{
  SIForce       *m;
  SIForceListSt *next, *prev;

  if ( e == NULL ) {
    cout << "SIForceList::del (0) : attempting to delete a NULL list element" << endl;
    exit(1);
  }
 
  m    = e->member;
  prev = e->prev;
  next = e->next;

  if ( prev ) prev->next = next;
  if ( next ) next->prev = prev;

  if ( e->cf ) delete e->member;
  delete e;

//(pCurr ? pCurr->next : pStart) = pEnd;
  if ( pEnd   == e )  pEnd   = prev;
  if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pStart == e )  pStart = next;

  num--;

  return m;
 
} // end of method del (0)


//************************************************************************************
//************************************************************************************
// METHOD     : del (1)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
SIForce *SIForceList::del(SIForce *m)
{
  SIForceListSt *e;

  if ( !(e=find(m)) ) return NULL;

  return del(e);
  
} // end of method del (1)


//************************************************************************************
//************************************************************************************
// METHOD     : del (2)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
SIForce *SIForceList::del(GINT  id)
{ 
  
  SIForceListSt *e;
  
  if ( !(e=find(id)) ) return NULL;

  return del(e);

} // end of method del (2)


//************************************************************************************
//************************************************************************************
// METHOD     : size
// DESCRIPTION:
// RETURNS    :  size of list
//************************************************************************************
GINT  SIForceList::size() const
{
  return num ;
} // end of method size


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : start
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
 void SIForceList::start(SIForceListSt *p = NULL)
{
  pCurr = ( p!=NULL ? p : pStart );
} // end of method start


//************************************************************************************
//************************************************************************************
// METHOD     : member (1)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
SIForce *SIForceList::member()
{
  SIForceListSt *e;
  e = pCurr ? pCurr : pEnd;

  if ( e == NULL ) return NULL;

  return e->member;



} // end of method member (1)


//************************************************************************************
//************************************************************************************
// METHOD     : member (2)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
SIForce *SIForceList::member(GINT  id)
{
  SIForceListSt *e;

  if ( (e=find(id)) == NULL ) return NULL;

  return e->member;
} // end of method member (2)


//************************************************************************************
//************************************************************************************
// METHOD     : next
// DESCRIPTION: 
// RETURNS    :  
//************************************************************************************
SIForceListSt *SIForceList::next()
{
  SIForceListSt *p = pCurr;
  if ( pCurr != NULL ) p = pCurr->next;
  pCurr = p;
  return pCurr;
} // end of method next
#endif

//************************************************************************************
//************************************************************************************
// METHOD     : curr
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
SIForceListSt *SIForceList::curr()
{
  return pCurr;
} // end of method curr


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : find (1)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
SIForceListSt *SIForceList::find(GINT  id)
{

  SIForceListSt *p=pCurr;

  // check from current pointer first:
  if ( p && p->id == id ) return p;
  else if ( p && p->next && p->next->id == id ) {
    next();
    return p->next;
  }

  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL ) {
    if ( p->id == id ) return p;
    next();
  }
  return NULL;

} // end of method find (1)


//************************************************************************************
//************************************************************************************
// METHOD     : find (2)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
SIForceListSt *SIForceList::find(SIForce *member)
{

  SIForceListSt *p=pCurr;

  // check from current pointer first:
  if ( p && p->member == member ) return p;
  else if ( p && p->next && p->next->member == member ) { 
     next();
     return p->next;
  }

  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL ) {
    if ( p->member == member ) return p;
    next();
  }
  return NULL;

} // end of method find (2)
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : empty
// DESCRIPTION:
// RETURNS    : delete list data
//************************************************************************************
void SIForceList::empty() 
{
  while ( pStart ) {
    pCurr = pStart;
    pStart = pStart->next;
    del (pCurr->id);
  }
  pStart = pEnd = pCurr = NULL;
  num = nid = 0;

} // end of method empty


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : operator()
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
SIForce *SIForceList::operator()(const GINT  iElem)
{
  SIForceListSt *tt;

  if ( (tt=find(iElem)) == NULL || tt->member == NULL ) {
    cout << "SIForceList::operator(): Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member;

} // end of method operator()


//************************************************************************************
//************************************************************************************
// METHOD     : operator[]
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
SIForce *SIForceList::operator[](const GINT  iElem)
{
  SIForceListSt *tt;

  if ( (tt=find(iElem)) == NULL || tt->member == NULL ) {
    cout << "SIForceList::operator[]: Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member;

} // end of method operator[]
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : renumber
// DESCRIPTION:
// RETURNS    : Renumber ids consecutively, used mainly after a delete
//************************************************************************************
GBOOL SIForceList::renumber()
{
  GINT          i=0;
  SIForceListSt *p;
//SIForceListSt *pkeep=curr();

  start(NULL);
  while ( (p=curr()) != NULL ) {
    p->id = i;
    next();
    i++;
  }
  nid = i;
  start(NULL);
  return TRUE;
} // end of method renumber



