//======================================================================================
// Name         :   reader.cpp
// Date         :   7/10/02 (DLR)
// Description  :   Test driver for GASpAR reader objects.
// Modifications:
//======================================================================================
#include "gtypes.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include "mesh_reader.hpp"


int main(int argc, char* argv[])
{
  SISIZE    i, n=0, ne;
  SISIZE    procid=1, *xN=NULL;
  SEIBuffer *bdy_nodes=NULL, *node_ids=NULL;
  SEBTBuffer *bctype=NULL;
  ELEMTYPE  etype;
  char      filename[FILENAME_MAX] ;
  Point3D   *vertices=NULL;

  MeshReader mr;

  strcpy(filename,"mesh.dat");

  if ( !mr.Open(filename) )
  {
    cout << "Error in Open: " << mr.Error() << endl;
    exit(1);
  }

  mr.SetProc(procid);
  ne = mr.GetNumElements();
  
  cout << "Data Dimension    : " << mr.GetDim() << endl;
  cout << "Num Procs         : " << mr.GetNumProcs() << endl;
  cout << "Total Num Elems   : " << mr.GetTotNumElements() << endl;
  cout << "Num Elems for proc: " << ne  << endl;

  while ( n<ne && mr.GetElem(etype, vertices, xN, node_ids, bdy_nodes, bctype)==0 )
  {
    cout << "Elem Type: " << etype << endl;
    for ( i=0; i<4; i++ )
    cout << "Vertices : (" << i << "): " <<  vertices[i].x1 << " " << vertices[i].x2 << endl;
   
    cout << "Node ids     :" << *node_ids << endl;
    if ( bdy_nodes )
    {
      cout << "Bdy node ids :" << *bdy_nodes << endl;
      cout << "Bdy conds    :" << *bctype << endl;
      cout << endl;
    }
    n++;
  }
  
  cout << "Error: " << mr.Error() << endl;

  mr.Close();
  
} 
