#! /bin/tcsh
setenv HOME gauss_test
setenv NPMIN  5
setenv NPMAX  13
setenv DELNP  2
setenv NR     3
setenv DOEQUIV no

if ( $DOEQUIV == 'yes' ) then
  setenv PREFMESH ../../data/cone_mesh_32x32
  setenv PREFILEN {$HOME}_eq4x4nr3
else
  setenv PREFMESH ../../data/cone_mesh_4x4
  setenv PREFILEN {$HOME}_nr{$NR}
endif
echo  making directory $HOME...
mkdir $HOME 
echo  copying data to directory $HOME...
cp gaspar_gauss.dat $HOME/.
echo  changing to directory $HOME...
cd {$HOME}
@ I = $NPMIN
while ($I <= $NPMAX)
  setenv MESH {$PREFMESH}_n{$I}_p.dat
  setenv FILEN  {$PREFILEN}_n{$I}
  setenv LOGF log.{$FILEN}
  echo  making run directory $FILEN...
  mkdir {$FILEN}
  cp gaspar_gauss.dat $FILEN/.
  echo  changing to directory $FILEN...
  cd {$FILEN}
# echo MESH={$MESH}
# echo LOGF={$LOGF}
  setenv CALL "../../../bin/gaspar -if gaspar_gauss.dat -c 0.2 -time 0.2 -nr $NR -m $MESH -of $FILEN -lf $LOGF"
  echo running $CALL ...
  $CALL >&! err{$I}
  echo $CALL .............. done.
  @ I = $I + $DELNP
  cd ..
end
cd ..

