//************************************************************************************
// Module       : cff_wrappers.hpp
// Date         : 2/17/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Wrappers for the Linear algebra Fortran functions
// Derived From : none.
// Modifications:
//************************************************************************************
#if !defined(CFF_WRAPPERS_HPP)
#define CFF_WRAPPERS_HPP

void w_dmxm  (GDOUBLE C[], GDOUBLE A[], GINT nai, GINT naj, GDOUBLE B[], GINT nbi, GINT nbj, GINT isz);
void w_dmxv   (GDOUBLE y[], GINT ny, GDOUBLE A[], GDOUBLE x[], GINT nx, GINT isz);
void w_dmxDm  (GDOUBLE C[], GDOUBLE A[],GINT nai, GINT naj, GDOUBLE b[], GINT nb, GINT isz);
void w_dDmxm  (GDOUBLE C[], GDOUBLE a[], GINT na, GDOUBLE B[], GINT nbi, GINT nbj, GINT isz);
void w_dzaxpby(GDOUBLE z[], GDOUBLE x[], GDOUBLE a, GDOUBLE y[], GDOUBLE b, GINT nxy, GINT isz);
void w_dxaxpby(GDOUBLE x[], GDOUBLE a, GDOUBLE y[], GDOUBLE b, GINT nxy, GINT isz);
void w_dzvxvpt(GDOUBLE z[], GDOUBLE x[], GDOUBLE y[], GINT nxy, GINT isz);
void w_dvvxvpt(GDOUBLE x[], GDOUBLE y[], GINT nxy, GINT isz);
void w_ddot   (GDOUBLE *dot, GDOUBLE x[], GDOUBLE y[], GINT nxy, GINT isz);
void w_dcopy  (GDOUBLE x[], GDOUBLE y[], GINT nxy, GINT isz);

#endif
