//************************************************************************************//
// Module       : gcommdata_t.h
// Date         : 8/20/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Provides global data types for GASpAR comm code. These types
//                correspond in kind with the GASpAR scientific processing portion,
//                as contained in gtypes.h
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GCOMMDATA_T_H)
#define GCOMMDATA_T_H

#include "gtypes.h"


//--------------------------------------------------------------------------------
// Comm Datatypes
//--------------------------------------------------------------------------------
#if defined(MPI_GENERIC_DEFAULT)
#  include "mpi.h"

//  Just take the MPI defs...
#define GCommDatatype   MPI_Datatype
#define GC_GDOUBLE      MPI_DOUBLE
#define GC_GFLOAT       MPI_FLOAT
#define GC_GQUAD        MPI_LONG_DOUBLE
#define GC_GINT         MPI_INT
#define GC_GSHORT       MPI_SHORT
#define GC_GUSHORT      MPI_UNSIGNED
#define GC_GLONG        MPI_LONG
#define GC_BYTE         MPI_UNSIGNED_CHAR
#define GC_GUCHAR       MPI_UNSIGNED_CHAR
#define GC_ISUB         MPI_SHORT
#define GC_GWORD        MPI_INT
#define GC_GDWORD       MPI_LONG
#define GC_GFPOS        MPI_LONG_LONG_INT
#define GC_GNODEID      MPI_LONG_LONG_INT
#define GC_GKEY         MPI_LONG_LONG_INT
#define AGINT           MPI_Aint
#else
//  Else, define the types as sizes, so that we can just do a memcpy
//  NOTE: How might this have to be changed if using other than MPI?
#define GCommDatatype   GINT  
#define GC_GDOUBLE      sizeof(GDOUBLE)
#define GC_GFLOAT       sizeof(GFLOAT)
#define GC_GQUAD        sizeof(GQUAD)
#define GC_GINT         sizeof(GINT )
#define GC_GSHORT       sizeof(GSHORT )
#define GC_GUSHORT      sizeof(GUSHORT )
#define GC_GLONG        sizeof(GLONG )
#define GC_BYTE         sizeof(GBYTE)
#define GC_GUCHAR       sizeof(GUCHAR)
#define GC_ISUB         sizeof(ISUB)
#define GC_GWORD        sizeof(GWORD)
#define GC_GDWORD       sizeof(GDWORD)
#define GC_GFPOS        sizeof(GFPOS)
#define GC_GNODEID      sizeof(GNODEID)
#define GC_GKEY         sizeof(GKEY)
#define AGINT           GINT 
#endif

#define GC_DATATYPE     GCommDatatype  

#endif
