//************************************************************************************//
// Module       : glop.hpp
// Date         : 2/14/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a geometry--free global gather/scatter operator
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GLOP_HPP)
#define GLOP_HPP

#include "elem2d.hpp"
#include "gtvector.hpp"
#include "gtbuffer.hpp"
#include "gttlist.hpp"
#include "gs.hpp"
#include "gcomm.hpp"

#if defined(DO_GLOP_TIMING)
enum SETIMER_RESULT_T {SETTR_OP, SETTR_EXCH};
#endif

class GlOp: public GS 
{
public:
                  GlOp();
                 ~GlOp();
                  GlOp(const GlOp &a);
GlOp             &operator=(const GlOp &);
                   

GCHandle          Init(GNIDBuffer  *glob_index, GNODEID maxindex);
GBOOL             DoOp (GDOUBLE *u,  GINT  ulen, G_OP op, GCHandle hand);
GVector           DoOp (GVector &u,  G_OP op, GCHandle hand);
GBOOL             DSOp (GVector **u,  GINT  nop, G_OP op, GCHandle hand);
GBOOL             DSOp (GVecList &u,   G_OP op, GCHandle hand);
#if defined (GENERALIZED_EXCHANGE)
GBOOL             DoOp (void *u,  GINT  ulen, GC_DATATYPE dtype, G_OP op, GCHandle hand);
#endif
GVector          *iMultiplicity(GINT  ie, GCHandle hand);
GBOOL             FreeHandle(GCHandle);

#if defined(DO_GLOP_TIMING)
GDOUBLE             GetTimes(SETIMER_RESULT_T type);
#endif

private:
// Private methods:
 
// Init-specific methods:
GCHandle          InitSort(GNIDBuffer  *glob_index, GNODEID MaxNodes, 
                          GNIDBuffer  **&irPrBin, 
                          GINT  &numRecvBins, GINT  &maxSharedNodes,
                          GINT  &PRrec_len );
GINT              BinSort(GNIDBuffer  *glob_indices,  
                          GIBuffer  *&bInRange_, GIBuffer  *&nInRange_, GNIDBuffer  *&iWorkNodes_);

GBOOL             DoCommonNodeSort(GINT  maxSharedNodes, GINT  Proc_rec_length,
                                   GNIDBuffer  *Input[], GSBuffer   *procIDs, 
                                   GNIDBuffer   *ProcSortOutput[], 
                                   const GINT  NumberOfListBuffers);
GBOOL             Repack(GNIDBuffer  **, GINT , GINT , GINT , GINT , GSBuffer  *&,
                         GNIDBuffer  **&, GINT  & );
GBOOL             GetRecord(GINT  index, GNIDBuffer  *rec_buff, GINT  max_length,
                            GNODEID *iGlobal, GSHORT  *&proc_buff, GSHORT  &num_procs);
GBOOL             BinFill(GNIDBuffer  *nodelist, GNIDBuffer  *bins[]);

// DoOp(1)-specific methods:
GBOOL             CombineLocal(GDOUBLE *u, GINT  n, GIBuffer  **ilocal, GINT  n_comb, G_OP op, GDOUBLE *result);
GBOOL             SetGlobalNodeVal(GCHandle h, GDOUBLE *u, GINT  n, const GNODEID glNode, const GDOUBLE val);
GBOOL             Data_Exchange     (GCHandle h, GDOUBLE *send_data, GDOUBLE *recv_data, GINT  &n_recv);

#if defined (GENERALIZED_EXCHANGE)
DoOp(2)- specific methods:
GBOOL             CombineLocal(void *u, GINT  n, GC_DATATYPE dtype, GIBuffer  **ilocal, GINT  n_comb, G_OP op, void *&result);
GBOOL             SetGlobalNodeVal(GCHandle h, void *u, GINT  n, GC_DATATYPE dtype, GNODEID glNode, void *val);
GBOOL             Data_Exchange     (GCHandle h, void *send_data, void *&recv_data, GINT  &n_recv, GC_DATATYPE dtype, GIBuffer  *&list);
#endif

// Handle-specific methods:
GCHandle          GetNewHandle();
GSHORT            HandleIndex(GCHandle h );
void              FreeHandleMem(GCHandle h );
GINT              GlobalToLocal(GNIDBuffer  *g2lbuffer,GINT  istart,  GNODEID global_index);
GBOOL             GetMultiplicity(GNIDBuffer  *inlist, GNIDBuffer  *&distinct_nodes, 
                                  GIBuffer   **&index_buffs);
GBOOL             ComputeGlobalMultiplicity(GCHandle hand, GVector *&global_mult_buff);

// General utilities:
GBOOL             IndexSort(GNIDBuffer  &);
GBOOL             IndexSort(GNIDBuffer  &, GIBuffer  &);
#if  defined(GBUFF_DEF_GSHORT)
GBOOL             IndexSort(GSBuffer  &);
GBOOL             IndexSort(GSBuffer  &, GIBuffer  &);
#endif
void              DeleteDynamic();

// Private data:
GSHORT             NProcs;                            // number of processors
GNODEID            nMaxNodes;                         // total number of nodes distributed among all procs
GINT               numGlNode_buffs  [MAX_OPHANDLES];  // number of proc ids(and gl. node buffers), to exchange data with in DoOp
GINT               maxsend          [MAX_OPHANDLES];  // max number of procs to send to
GINT               n_recv           [MAX_OPHANDLES];  // number of procs to recv from
GINT               n_recv_data      [MAX_OPHANDLES];  // number of procs to recv from
GINT               iLocalStack;                       // used for repeat call to GlobalToLocal 
GSHORT             rank;                              // rank of current processor
GSHORT             nUsedHandles;                      // number of handles from pool that are used
GCHBuffer         *opHandle;                          // global operation handle pool
CHandle           *rhandle          [MAX_OPHANDLES];  // basic communication handles
GDOUBLE           *lresult          [MAX_OPHANDLES];  // local op result buffer
GDOUBLE           *gresult          [MAX_OPHANDLES];  // global op result buffer
GSBuffer          *iUsedHandles;                      // indices of used handles
GSBuffer          *srProc_list      [MAX_OPHANDLES];  // proc ids with which to exchange global node values
GIBuffer          *index            [MAX_OPHANDLES];  // local indices in DoOp
GIBuffer          **node_indices_op [MAX_OPHANDLES];  // node indices in DoOp
GNIDBuffer        **srGlNode_buffs  [MAX_OPHANDLES];  // repacked sorted data used by DoOp, containing global nodes to be exchanged with other procs
GNIDBuffer        *LocToGlob        [MAX_OPHANDLES];  // stores the global indices used in call to Init
GINT              **ig2l            [MAX_OPHANDLES];  // stores the global-to-local index transformations
GNIDBuffer        *glob_dups        [MAX_OPHANDLES];  // indices among the LocToGlob which are duplicated--for local operations
GIBuffer          **local_op_indices[MAX_OPHANDLES];  // those indices among the LocToGlob which are duplicated--for local operations
GDBuffer          *u_send           [MAX_OPHANDLES];  // send buffers
GDBuffer          *u_recv           [MAX_OPHANDLES];  // receive buffers
GVector           *gmultiplicity    [MAX_OPHANDLES];  // global id multiplicity
GVector           *vflat            [MAX_OPHANDLES];  // 'flat' vectors used for direct stiffness ops--one for each handle
GNIDBuffer        *g2lbuff;                           // used for repeat call to GlobalToLocal
GNIDBuffer        *glNodeList       [MAX_OPHANDLES];  // used for call to DoOp
GNIDBuffer        *distinct_nodes_op[MAX_OPHANDLES];  // used for call to DoOp

#if defined(DO_GLOP_TIMING)
GDOUBLE              doop_time;
GDOUBLE              exch_time;
#endif

};
#endif

