//************************************************************************************//
// Module       : gneighbor.cpp
// Date         : 7/10/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a GASpAR element neighbor
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GNEIGHBOR_HPP)
#define GNEIGHBOR_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "vdbdata.hpp"


class GNeighbor
{
public:

                           GNeighbor();
                          ~GNeighbor();

inline   GSHORT             &proc        () { return proc_id_; }       // Get proc id
inline   GKEY              &elemkey     () { return elem_key_; }      // Get element key
inline   GKEY              &elemrootkey () { return elem_root_key_; } // Get element root key
inline   GINT              &elemid      () { return elem_id_; }       // Get elem id
inline   GINT              &compid      () { return comp_id_; }       // Get vertex/edge/face number (component) id
inline   GINT              &ancillary   () { return iancillary_; }    // Get starting index 
inline   void              operator=(VDBData &p)
  { proc_id_ = p.proc(); elem_id_ = p.hostid(); comp_id_ = p.localid();
    elem_key_ = p.hostkey(); elem_root_key_ = p.hostrootkey(); } 

         friend ostream &operator<<(ostream &str, GNeighbor &a);  // output stream operator

private:

         // Member data:
         GSHORT             proc_id_;
         GINT              iancillary_;
         GINT              comp_id_;
         GINT              elem_id_;                                            
         GKEY              elem_key_;                                            
         GKEY              elem_root_key_;                                            

};

#endif
