//************************************************************************************//
// Module       : gpartitioner.hpp
// Date         : 6/9/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                partitioning of data/elements among processors.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GPARTITIONER_HPP)
#define GPARTITIONER_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "gelemlist.hpp"
#include "gelemindex.hpp"
#include "gfieldlist.hpp"
#include "gcomm.hpp"
#include "gtlist.hpp"
#include "gobjlist.hpp"
#include "gobjbuffer.hpp"
#include "gpobjbuffer.hpp"
#include "gpartmapper.hpp"


class GPartitioner 
{
public:
                           GPartitioner(GElemList *gelemsv, GFieldList **gfieldsv, GINT nfieldsv);
                          ~GPartitioner();

         GBOOL             Init(stGPartitionMap pm[], GINT nmax);                    // Set partition map data
         GBOOL             SetBasisPools(pGLLBuffer *vbasis, GIBuffer *szvbasis,
                                         pGLBuffer  *pbasis, GIBuffer *szpbasis);
         GBOOL             SetFieldGroup(GElemList *gelems, GFieldList **gfields, GINT nfields);
                                                                                     // Set additional field groups
         GBOOL             DoPartition();                                            // Carry out data exchange/repartitioning

private:
         // Methods: 
         GBOOL             PostReceives();                                           // Post receives of data from other procs
         GBOOL             WaitOnRecvs();                                            // Waits on recvs from all procs
         GBOOL             SendData    ();                                           // Send elements/fields to other procs, delete from here
         GBOOL             Pack(GDOUBLE *cdata, GINT ndata, GINT field_index[], GINT nflds); 
                                                                                     // Bundle field data into comm packet
         GBOOL             Unpack(GDOUBLE *cdata, GINT ndata);                       // Unbundle field data from comm packet
         GBOOL             Unpack();                                                 // Unbundle field data from all comm packets
         GBOOL             CleanFieldLists();                                        // Remove unnec. fields/elems from lists
         GBOOL             CreateSendRecvBuffs();                                    // Set up send/recv buffers

         // Member data
         GSHORT            nprocs_;            // number of procs
         GSHORT            this_rank_;         // this proc's rank
         GBOOL             bInitialized_;      // object initialized?
         GBOOL             bdelete_partmap_;   // delete partmap variable?
         GINT              nfieldsv_;          // number of v-fields
         GINT              nfieldsp_;          // number of v-fields
         GINT              npartmax_;          // max number of sends among all processors
         GINT              maxvnodes_;         // max number of v-nodes
         GINT              maxpnodes_;         // max number of p-nodes
         GINT              maxedges_;          // max number of edges
         GINT              maxfaces_;          // max number of faces
         GINT              maxverts_;          // max number of element vertices
         GINT              maxnto_;            // max number of elements to send among all procs
         GINT              maxlevels_;         // max no. time levels for each field
         GINT              nto_;               // number of procs to send data to
         GINT              nfrom_;             // number of procs to recv data from 
         GINT              lbuff_;             // send/recv buffer lens
         GDBuffer          sendbuff_;          // send buffer
         GDBuffer          *recvbuff_;         // receive buffers
         GIBuffer          index_to_;          // indices in gelems/gfields to send to procs
         GIBuffer          *szbasisv_;         // array of v-basis sizes
         GIBuffer          *szbasisp_;         // array of p-basis sizes
         GSBuffer          iproc_to_;          // procs where to send data, pointed to by indices in indices2send_
         GSBuffer          iproc_from_;        // procs from which to recv data
         CHBuffer          rhandle_;           // comm handle array for posted receives
         pGLLBuffer        *gbasisv_;          // pool of v-bases
         pGLBuffer         *gbasisp_;          // pool of p-bases
         GElemList         *gelemsv_;          // v-Element list
         GElemList         *gelemsp_;          // p-Element list
         GFieldList        **gfieldsv_;        // v-field list
         GFieldList        **gfieldsp_;        // p-field list
         stGPartitionMap   *partmap_;          // partition map
         GFGList           fieldgroups_;       // field group list

};

#endif
