//************************************************************************************//
// Module       : mesh_reader.hpp
// Date         : 7/17/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the object that reads a mesh file
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(MESH_READER_HPP)
#define MESH_READER_HPP 
#include "gtypes.h"
#include "gdd_file.h"
#include "gtbuffer.hpp"
#include "point.hpp"
#include <iostream.h>
#include <fstream.h>
#include <limits.h>

extern char *serror_[] ;
enum ERRNO {
            ERRNONE     , ERREOF     , ERRFILENAME,
            ERRHEADER   , ERRFILETYPE, ERRCORRUPT,
            ERRDIMENSION, ERRNODATA  , ERRNOFILE ,
            ERRMISC     , ERRMALLOC  , ERRDATANOTFND,
            ERRBADDATA  , ERRHAVEDATA  
           }; 

class MeshReader
{
public:
                          MeshReader(GLONG maxbuff=7500000);
//                        MeshReader(const MeshReader &);
                          ~MeshReader();
         GBOOL             Open(const char *);
         void              Close();
         void              SetProc(GSHORT  id);
         void              bGetNodeIDs(GBOOL bid);
         const char       *Error();
         GSHORT            ErrorID();
         GSHORT            GetNumRetrieved();
         GSHORT            GetGlobalVerts(Point *&verts, GINT  &nverts);
         GSHORT            GetNumElements();
         GLONG             GetDynRange();
         GSHORT            GetTotNumElements();
         GSHORT            GetNumProcs();
         GSHORT            GetDim();
         GSHORT            GetElem(ELEMTYPE &etype, Point3D *&vertex, GSHORT  *&bdyn, GLONG *&xN, 
                                  GLBuffer  *&node_ids, GLBuffer  *&bdy_nodes, GBTBuffer  *&bct );

private:
//    methods:
         GBOOL             ReadHeader();
         GSHORT            GetElemData(GSHORT  &elemid, GSHORT  &procid, ELEMTYPE &etype, Point3D *&vertex,
                                      GSHORT  *&bdyn, GLONG  *&xN, GLBuffer  *&node_ids, GLBuffer  *&bdy_nodes, 
                                      GBTBuffer  *&bct, const GBOOL bautofill);
         GBOOL            LocateProcID();
         GLONG            getdata_t(char *sdata, G_DATATYPE dtype, const char *datadelim, const char *termdelim, 
                                    void *data, const GLONG ndata);
         GLONG            getline(char *sbuff, const GLONG num, const char *delim);
         GBOOL            getblock(char *sbuff, GLONG  num, char *delim0, char *delim1);
         GBOOL            ignore(const char *str);
         GBOOL            skipblock(const char *delim0, const char *delim1);
         GBOOL            skiptoblock(const char *blk_delim, const char *header_delim);

//    data:
         GDD_FILE_TYPE    ftype_;
         GLONG            buffsize_;
         GBOOL            bnodes_;
         GBOOL            blocated_;
         GBOOL            bGetNodeIDs_;
         ERRNO            ierror_;
         GSHORT           procid_;
         GSHORT           nd_;
         GSHORT           np_;
         GSHORT           ne_;
         GLONG            nrng_;
         GSHORT           ientry_;
         GSHORT           *elemperproc_;
         GSHORT           ngverts_;
         Point            *gverts_;
         char             *buff_;
         char             *filename_;
         char             delimelem_[2][DELIM_MAX+1];
         char             delimproc_[2][DELIM_MAX+1];
         char             delimeol_    [DELIM_MAX+1];
         char             delimlist_   [DELIM_MAX+1];
         ifstream        *os_;
 
};

#endif
