//************************************************************************************//
// Module       : morton_keygen.cpp
// Date         : 8/25/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a Morton-type key-generator, as used in GASpAR. 
//                objects
// Derived From : Morton_KeyGen
// Modifications:
//************************************************************************************//
#if !defined(MORTON_KEYGEN_HPP)
#define MORTON_KEYGEN_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "point.hpp"
#include "gkeygen.hpp"
#include "bitblock.hpp"

class Morton_KeyGen: public GKeyGen
{
public:
         enum    MORTON_TYPE {MORTON_PARTIAL_INTERLEAVE, MORTON_FULL_INTERLEAVE};

                           Morton_KeyGen(MORTON_TYPE type=MORTON_FULL_INTERLEAVE);
                          ~Morton_KeyGen();

         void              SetType(MORTON_TYPE type);                               // Set Morton-order method
         void              SetOrigin(Point3D &P0);                                  // Set coord origin
         void              SetBox(Point &inP0, Point &inP1);                        // Set grid bding box
         void              SetIntegralLen(Point3D &dX);                             // Set integral length
         void              SetDoLog(GBOOL bDoLog);                                 // Set btakelog_ flag
         void              key(void *id, GINT idsz, Point3D point[], GINT  n=1);   // Get key/id data
         void              key(void *id, GINT idsz, GDOUBLE   *x   [], GINT  n=1); // Get key/id data


private:

         // Member data:
         MORTON_TYPE       itype_;
         GINT              ksz_;
         GBOOL             btakelog_;
         GDOUBLE           logFact_;
         GDOUBLE           delmax_;
         GDOUBLE           idelmax_;
         GDOUBLE           idel_;
         Point3D           P0_;
         Point3D           P1_;
         Point3D           idX_;
         Point3D           dX_;
         BitBlock          *bb;
};

#endif
