//======================================================================================
// Name         : gaspar_out.cpp
// Date         : 11/10/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : GASpAR output module
// Modifications:
//======================================================================================
#include "gaspar_t.h"
#include "guser.h"


//************************************************************************************
// METHOD     : GOutput
// DESCRIPTION:
// ARGUMENTS  :
// RETURNS    :
//************************************************************************************
GBOOL GOutput()
{
  GBOOL   bRet;
  GDOUBLE T0, T1;
  
  T0 = STK::CTimer(); T1 = STK::Timer ();

  if      ( iOutType_ == OUT_BIN ) {
    bRet = GOutBin();
    if ( !bRet ) {
      iGError_ = GERR_OUT;
      GDoLog(0,"#GOutput failure: GOutBin");
      return FALSE;
    }
  }
  else if ( iOutType_ == OUT_SDS ) {
    bRet = GOutSDS();
    if ( !bRet ) {
      GDoLog(0,"#GOutput failure: GOutSDS");
      iGError_ = GERR_OUT;
      return FALSE;
    }
  }
  else {
    cout << "GOutput: Unrecognized output method" << endl;
    iGError_ = GERR_OUT;
    return FALSE;
  }

  TCOut_ += (STK::CTimer()-T0); TWOut_ += ((STK::Timer ()-T1)/1.0e6);

  return TRUE;
} // end of method GOutput

//************************************************************************************
// METHOD     : GOutBin
// DESCRIPTION:
// ARGUMENTS  :
// RETURNS    :
//************************************************************************************
GBOOL GOutBin()
{
  char       *serr =  "GOutBin: ";
  GINT       i, j, k, n, idims[3], NN, nv, nm, nb, nt=4;
  GDOUBLE    tag[4], *fmeta ;
  GBOOL      bRet;
  Point      *vert;
  GVector    *uu=NULL, *uua=NULL, *dv[2];
  Elem2D     *e;
  char       fn[FILE_NAME_MAX] , slabel[FILE_NAME_MAX] ;
#if defined(MPI_IO_DEFAULT)
  GBinWriter wgbin(TRUE,TRUE,GComm::WorldRank()/NPROCESSES_PER_NODE); // Collective, independent writes
#else
  GBinWriter wgbin;
#endif

  if ( !(bOutOnGridChange_ && bElemListChange_) ) {
    time_out_last_   = time_;
    icycle_out_last_ = icycle_;
  }

  sprintf(fn,"%s.%07d",fnout_,icycle_);
  if ( !wgbin.Open(fn,gios::inout|gios::create, TRUE) ) {
     cout << serr << "Open failed for file " << fn << 
             "; Writer error: " << wgbin.Error() << endl;
     return FALSE;
  }
  wgbin.InitCommList(nelems_);

  // Create and set meta data:
  nb       = (GINT )pow(2.0,(GSHORT)nd_);
//ndmpmeta_= nb + 25;
  fmeta = new GDOUBLE [ndmpmeta_];

  fmeta [0] = (GDOUBLE)icycle_;
  fmeta [1] = (GDOUBLE)icycle_max_;
  fmeta [2] = (GDOUBLE)icycle_out_beg_;
  fmeta [3] = (GDOUBLE)icycle_out_end_;
  fmeta [4] = (GDOUBLE)icycle_out_skip_;
  fmeta [5] = (GDOUBLE)icycle_out_last_;
  fmeta [6] = (GDOUBLE)icycle_dmp_beg_;
  fmeta [7] = (GDOUBLE)icycle_dmp_skip_;
  fmeta [8] = (GDOUBLE)icycle_log_skip_;
  fmeta [9] = (GDOUBLE)dt_;
  fmeta[10] = (GDOUBLE)time_;
  fmeta[11] = (GDOUBLE)time_max_;
  fmeta[12] = (GDOUBLE)time_out_beg_;
  fmeta[13] = (GDOUBLE)time_out_end_;
  fmeta[14] = (GDOUBLE)time_out_skip_;
  fmeta[15] = (GDOUBLE)time_out_last_;
  fmeta[16] = (GDOUBLE)iStopCond_;
  fmeta[17] = (GDOUBLE)iOutType_;
  fmeta[18] = (GDOUBLE)bUPC;
  fmeta[19] = (GDOUBLE)bPPC;
  fmeta[20] = (GDOUBLE)upc_type_;
  fmeta[21] = (GDOUBLE)stokes_type_;
  fmeta[22] = (GDOUBLE)nu_[0];
  fmeta[23] = (GDOUBLE)nu_[1];
  fmeta[24] = (GDOUBLE)rho_;
  n = 25;
  for ( i=0; i<nb; i++,n++ )  {
    fmeta[nb+i] = (GDOUBLE)btype_[i];
  }
  wgbin.SetMeta(ndmpmeta_, fmeta, "GASPAR_OUTPUT_FILE");
 
  // Write datasets:
  tag[0] = time_;
  tag[1] = (GDOUBLE)icycle_;
  for ( k=0; k<GDIM           ; k++ ) if ( cadv_    [k] != NULL ) cadv_    [k]->start(NULL);
  for ( k=0; k<nEvolvedFields_; k++ ) if ( pgfields_[k] != NULL ) pgfields_[k]->start(NULL);
  for ( k=0; k<nUserFields_   ; k++ ) pufields_[k].start(NULL);
  for ( i=0, bRet=TRUE; i<nelems_ && bRet; i++ ) {
    // Write the GASpAR fields:
//  for ( k=0; k<nEvolvedFields_; k++ ) {
    for ( k=0; k<1; k++ ) {
      uu    = pgfields_[k]->member()->GetExpCoeffs(0);
      e     = pgfields_[k]->member()->GetElement();
      vert  = e->GetSpVertices(); nv     = e->GetNumVertices();
      tag[2] = (GDOUBLE)(e->GetID());
      tag[3] = (GDOUBLE)(e->GetParentID());
      for ( j=0,NN=1; j<nd_; j++ ) {
        idims[j] = e->GetOrder(j+1)+1;
        NN *= idims[j];
      }
      if ( !wgbin.SetDims(nd_, idims) ) bRet = FALSE;
      if ( !wgbin.SetVertices(nv, vert, e->ElemType()) ) bRet = FALSE;
      for ( j=0; j<GDIM && bRet; j++ ) {
        if ( e->GetSpNodes(j+1) != NULL ) { 
          sprintf(slabel, "%s%d", "X", j);
          bRet = wgbin.SetCoord(j+1, NN, e->GetSpNodes(j+1)->Data(), slabel);
        }
      }
      if ( !wgbin.WriteData(nd_, idims, uu->Data(), nt, tag, sDSLabel_[k], NULL) ) bRet = FALSE;
    } // end of evolved fields
    

    // Next, write the user fields:
    // NOTE: this assumes that the user fields reside on the same
    //       grid as the GASpAR fields....
    for ( k=0; k<nUserFields_; k++ ) {  
      uu    = pufields_[k].member()->GetExpCoeffs(0);
      e     = pufields_[k].member()->GetElement();
      vert  = e->GetSpVertices(); nv     = e->GetNumVertices();
      tag[2] = (GDOUBLE)(e->GetID());
      tag[3] = (GDOUBLE)(e->GetParentID());
      for ( j=0,NN=1; j<nd_; j++ ) {
        idims[j] = e->GetOrder(j+1)+1;
        NN *= idims[j];
      }
      if ( !wgbin.SetDims(nd_, idims) ) bRet = FALSE;
      if ( !wgbin.SetVertices(nv, vert, e->ElemType()) ) bRet = FALSE;
      for ( j=0; j<GDIM && bRet; j++ ) {
        if ( e->GetSpNodes(j+1) != NULL ) { 
          sprintf(slabel, "%s%d", "UX", j);
          bRet = wgbin.SetCoord(j+1, NN, e->GetSpNodes(j+1)->Data(), slabel);
        }
      }
      if   ( sUDSLabel_.size() < (k+1) ) sprintf(slabel, "%s%d", "User", j);
      else                               sprintf(slabel, "%s", sUDSLabel_[k].c_str());
      if ( !wgbin.WriteData(nd_, idims, uu->Data(), nt, tag, slabel, NULL) ) bRet = FALSE;
    } // end of user fields

    // Next, write advection velocity fields:
    for ( j=0; j<GDIM && bRet && bLinAdvection_; j++ ) {
      if ( cadv_[j] != NULL ) {
        uu   = cadv_[j]->member()->GetExpCoeffs(0);
        bRet = wgbin.WriteData(nd_, idims, uu->Data(), nt, tag, sCAdvLabel[j], NULL);
      }
    }  // end of cadv fields

    for ( k=0; k<GDIM           ; k++ ) if ( cadv_    [k] != NULL ) cadv_    [k]->next();
    for ( k=0; k<nEvolvedFields_; k++ ) if ( pgfields_[k] != NULL ) pgfields_[k]->next();
    for ( k=0; k<nUserFields_   ; k++ ) pufields_[k].next();
    wgbin.EndLoop(i);
  }   // end of elem_list

  wgbin.Close();
  GComm::Synch();
  if ( fmeta ) delete [] fmeta; 

  if ( !bRet ) {
    cout << "OutGBin: GBin write error: " << wgbin.Error() << endl;
  }

  return bRet;

} // end of method GOutBin


//************************************************************************************
// METHOD     : GOutSDS
// DESCRIPTION:
// ARGUMENTS  :
// RETURNS    :
//************************************************************************************
GBOOL GOutSDS()
{
  char      fn[80];

  time_out_last_   = time_;
  icycle_out_last_ = icycle_;

#if defined(BURGERS)
  sprintf(fn,"v1_%s.%d",fnout_,icycle_);
  if ( !GPutSDS(fn, u1) ) {
    cout << "GOutSDS: error in writing u1 SDS data" << endl;
    return FALSE;
  }
  if ( nEvolvedFields_ > 1 && !GPutSDS(fn, u1) ) {
    cout << "GOutSDS: error in writing u2 SDS data" << endl;
    return FALSE;
  }
#else
  sprintf(fn,"v1_%s.%d",fnout_,icycle_);
  if ( !GPutSDS(fn, u1) ) {
    cout << "GOutSDS: error in writing u1 SDS data" << endl;
    return FALSE;
  }
  if ( nd_ > 1 ) {
    sprintf(fn,"v2_%s.%d",fnout_,icycle_);
    if ( !GPutSDS(fn, u2) ) {
      cout << "GOutSDS: error in writing u2 SDS data" << endl;
      return FALSE;
    }
  }
  if ( nd_ > 2 ) {
    sprintf(fn,"v3_%s.%d",fnout_,icycle_);
    if ( !GPutSDS(fn, u3) ) {
      cout << "GOutSDS: error in writing u3 SDS data" << endl;
      return FALSE;
    }
  }
  sprintf(fn,"p_%s.%d",fnout_,icycle_);
  if ( !GPutSDS(fn, p) ) {
    cout << "GOutSDS: error in writing p SDS data" << endl;
    return FALSE;
  }
#endif

  return TRUE;
} // end of method GOutSDS


//************************************************************************************
// METHOD     : GPutSDS
// DESCRIPTION:
// ARGUMENTS  :
// RETURNS    :
//************************************************************************************
GBOOL GPutSDS(char *filename, GFieldList &f)
{
#if 0
  GINT      i, nv, N[3], NN;
  Point    *vert;
  GVector  *uf, *x, *y, *z;
  Elem2D   *e;
  char     sElemGroup[80];
  HDFFile  *osds=NULL;

  osds  = new HDFFile(filename);
  if ( osds == NULL || !osds->createOpen(TRUE) ) {
    cout << "GPutSDS: error in creating HDF writer, '" << filename << "'" << endl;
    return FALSE;
  }

  nv     = (GINT )(nd_*pow(2.0,nd_));
  if ( !osds->writeMeta("TIME"     ,sdsobj->getCurrentHDFObj(),time_) ) { bRet = FALSE; goto cleanup;}
  if ( !osds->writeMeta("DIMENSION",sdsv1->getCurrentHDFObj() ,nd_  ) ) { bRet = FALSE; goto cleanup;}
  if ( !osds->writeMeta("PROCID"   ,sdsv1->getCurrentHDFObj() ,rank ) ) { bRet = FALSE; goto cleanup;}
  f.start(NULL);
  for ( i=0; i<nelems_; i++ ) {
    u     = f.member()->GetExpCoeffs(0);
    e     = f.member()->GetElement();
    N[0]  = e->GetOrder  (1) + 1; N[1] = e->GetOrder  (2) + 1;  N[2] = e->GetOrder  (3) + 1;
    x     = e->GetSpNodes(1)    ; y    = e->GetSpNodes(2)    ;  z    = e->GetSpNodes(3)    ;
    vert  = e->GetSpvVertices();
    NN    = N[0]*N[1]*N[2];
    sprintf(sElemGroup,"ELEMID_%d", i);
    if ( !osds->createGroup(sElemGroup)  ) { bRet = FALSE; goto cleanup};
    if ( !osds->writeMeta  ("VERTICES", sdsp->getCurrentHDFObj(),vert,nv) ) { bRet = FALSE; goto cleanup;}
    if ( !osds->writeVector("PRESSURE", u->Data()               , NN)     ) { bRet = FALSE; goto cleanup;}
    f.next();
  } 
  osds->close();

cleanup:
  if ( sdu ) delete sdu;
#endif
  return TRUE;
} // end of method GPutSDS

