//************************************************************************************//
// Module       : gasparFileIO.hpp
// Date         : 8/02/02 (RMP)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                Gaspar file IO.
// Derived From : none.
// Modifications:
//************************************************************************************//

#if !defined(GASPARFILEIO_HPP)
#define GASPARFILEIO_HPP


#include "mpi.h"
#include "hdf5.h"
#include "gasparFile.hpp"
#include "hdfFile.hpp" 
#include "gtypes.h"
#include <iostream.h>
#include <string.h>

class GasparFileIO{

public:
  
  //public methods:
  GBOOL openFile(GasparFile* inFile, const FILE_ACCESS accessIn);
  GBOOL openHDF(const char* fileNameIn, const FILE_ACCESS accessIn, IO_TYPE fType = COLLECTIVE_IO, IO_TYPE dType = INDEPENDENT_IO, 
		MPI_Comm commIn = MPI_COMM_WORLD);
  GBOOL closeFile();

protected:

  //protected data:

  enum DATA_TYPE {FAIL, SEVECTOR, SEMATRIX};           //Data set type tag stored in file metadata
  static const char* DTYPE_META_NAME;                  //Name suffix used to ID data type meta data in file

  //protected methods:

  GasparFileIO(){}
  GasparFile* getFile(){ return file; }
  void setFile(GasparFile* fileIn){ file = fileIn; }
  GBOOL isOpen() const { return openStatus; }
  void setOpenStatus(GBOOL statusIn){ openStatus = statusIn; }

private:

  //private data:  
  GBOOL openStatus;
  GasparFile* file;
  static const char* THIS;                             //Class name used in error messages
};
#endif
