//************************************************************************************//
// Module       : gstream.hpp
// Date         : 12/10/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the GStream object.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GSTREAM_HPP)
#define GSTREAM_HPP 
#include "gtypes.h"
#include "gdd_file.h"
#include "gtbuffer.hpp"
#include <iostream.h>
#include <fstream.h>
#include "gcomm.hpp"
#include "gtbuffer.hpp"
#if defined(MPI_IO_DEFAULT)
#include "mpi.h"
#endif

extern char *streamerror_[] ;

class GStream: public fstream
{
public:
//   public  data:
#if defined(MPI_IO_DEFAULT)
         enum gios_open_mode {
         app       = MPI_MODE_APPEND,
         ate       = MPI_MODE_APPEND,
         binary    = 0,
         in        = MPI_MODE_RDONLY,
         nocreate  = 0,
         create    = MPI_MODE_CREATE,
         noreplace = MPI_MODE_EXCL,
         out       = MPI_MODE_WRONLY,
         inout     = MPI_MODE_RDWR,
         trunc     = ios::trunc};
//       trunc     = MPI_MODE_NOPRECEDE };
#else
         enum gios_open_mode {
         app       = ios::app,
         ate       = ios::ate,
         binary    = ios::binary,
         in        = ios::in,
         nocreate  = 0,  //ios::nocreate,
         create    = 0,
         noreplace = 0,  //ios::noreplace,
         out       = ios::out,
         inout     = ios::in | ios::out,
         trunc     = ios::trunc };
#endif

                          GStream(GBOOL isCollective=FALSE, GBOOL isIndependent=TRUE, GSHORT  ioTaskID=0);
//                        GStream(const GStream &);
                         ~GStream();
virtual  GBOOL            Open(const char *, GIOS_MODE iomode, GBOOL bDelete=FALSE);
virtual  void             Close();
         GBOOL            SetFileView(GFPOS disp);          // Set file view for collective writes
         void             FileSynch();                      // Synch file
         GBOOL            Access(char *fn);                 // Does file, fn, exist?
         const char      *Error();
         GINT             ErrorID();
         GBOOL            NewComm();

         void             InitCommList(GINT);
	 GBOOL		  SwitchedComms(GINT);
	 GBOOL		  SwitchingComms(GINT);
	 void 		  FinishedLoop();         

         void             read (GUCHAR *, GINT  nGUCHARs);
         void             get(char &ch);
         void             write(GUCHAR *, GINT  nGUCHARs);
         void             seekp(GFPOS offset, seek_dir origin);
         void             seekg(GFPOS offset, seek_dir origin);
         char             peek();
         GFPOS            tellp();
         GFPOS            tellg();
         GBOOL            eof(); 
         GBOOL            fail(); 
         GBOOL            ignore(const char *delim);


protected:
//    methods:

//    data:
         enum ERRNO {
            ERRNONE     , ERREOF         , ERRFILENAME,
            ERRHEADER   , ERRFILETYPE    , ERRCORRUPT,
            ERRDIMENSION, ERRNODATA      , ERRNOFILE ,
            ERRMISC     , ERRMALLOC      , ERRDATANOTFND,
            ERRBADDATA  , ERRHAVEDATA    , ERRBADSNUM,
            ERRMETAW    , ERRCOORDBLKW   , ERRDATABLKW,
            ERRMETAR    , ERRCOORDBLKR   , ERRDATABLKR ,
            ERRFILEXISTS, ERRFILENOTEXIST, ERRMPI      , ERRMAX
           };


         GINT             iLen_;
         ERRNO            ierror_;
         GBOOL            isOpen_;
         GBOOL            isFile_;
         GBOOL            iscollective_;
         GBOOL            isindependent_;
         GBOOL            deletefirst_;
         GBOOL            bNewComm_ ;          // was new comm created in call to EndLoop?        
         GSHORT           iotaskid_;
         GINT             nLoopPMax_;
         char             *filename_;
//       char             *serrmsg;
         char             sErr_[GMAX_ERROR_STRING];
         GIBuffer         procExcluded_;
         GIBuffer         pexcl_;
	 GIBuffer         nLoopP_;
	 GIBuffer         iRanks_;
         fstream          *ios_;

  	 void		  EndLoop(GINT index);

#if defined(MPI_IO_DEFAULT)
         MPI_File         fhMPI_;              // MPI file handle
         MPI_Offset       voffsetMPI_;         // MPI offset value (measured from beg. of MPI view)
         MPI_Offset       doffsetMPI_;         // MPI offset value (measured from beg. of file)
         MPI_Datatype     etypeMPI_;           // MPI datatype
         MPI_Datatype     filetypeMPI_;        // MPI file type
         MPI_Status       statusMPI_;          // MPI status flag
         MPI_Info         infoMPI_;            // MPI info structure
         MPI_Comm         IOCommMPI_;          // MPI communicator representing IO tasks
         MPI_Group        currentGroup_;       // MPI group used when not all processors are wanted
	 MPI_Group        groupWorld_;         // MPI group used when all processors are wanted
         GFPOS            putposnMPI_;         // put position w/in file = View offset + pviewMPI_
         GFPOS            getposnMPI_;         // get position w/in file = View offset + gviewMPI_
         GFPOS            pviewMPI_;           // put posn wrt process's MPI view
         GFPOS            gviewMPI_;           // get posn wrt process's MPI view
         GBOOL            bEvenDist_;          // is the total number of dataset loops same on all procs?
         GSHORT           ierrorMPI_;          // MPI error code
         GSHORT           *iotasklist_;        // IO task list: for each procid, its iotaskid_
         GSHORT           *sisterids_;         // Proc ids from which to receive data for output
         GINT             nrecvs_;             // Number of procs from which to recv data
         char             datarepMPI_[MPI_MAX_DATAREP_STRING];  // MPI data representation string


         GINT             PostDataRecvs(GUCHAR **&buff, GINT  maxbufflen);
         MPI_Comm         BuildComm();
#else
         GINT             IOCommMPI_;          // integer communicator representing IO tasks
#endif
private:
         void            DeleteDynamic(); 
         GBOOL           in_list(GSBuffer  *ilist, GINT  imember, GINT  &index);

};

#endif
