function [dm,tm]=Burg_min(nu)
%
% [dm tm]=Burg_min(nu);
%
% Given viscosity nu, return minimum slope dm at time tm, x=0 for the
% stationary 1D Burgers equation initialized with u(0,x)=-sin(pi*x).
%
ti=[.45 .55];			% initial interval
fhandle = @(t) duodx0(nu,t);	% du(0,t)/dx to be minimized
[tm dm]=fminbnd(fhandle,ti(1),ti(2));

function d=duodx0(nu,t)		% du(0,t)/dx function of t
[u p d]=BurgersH(nu,t,0);
