function [x,w]=Gauss(n,name)
%
% x=Gauss(n);
% x=Gauss(n,'Name');
% [x w]=Gauss(...);
%
% n+1 Gauss-Legendre or (-Name) nodes, using
% eigenvalues of the companion matrix
% of the monomial expansion, Funaro (1997 eq. A.1.2) <=>
% Courant & Hilbert p. 83.
% Optionally return weight vector w.
%
% Aime' Fournier 2001/6/25
%                2004/5/14 added Hermite
%
if nargin<2
   name='Legendre';
end
if n<0
   error('Gauss.m needs n>-1')
end
n=n+1;				% no. polynomials
if strcmp(name,'Legendre')	% c of Legendre polynomial:
   c=zeros(1,n+1);		% allocate coefficients c
   if mod(n,2)			% then n is odd:
      m=(n-1)/2;
      c(n  )=(-1)^m*factorial(n+1)/factorial(m+1)/factorial(m)/2^n;
      for j=0:m-1		% assign monomial coefficients:
         c(n-2-2*j)=(j-m)*(2*j+n+2)*c(n-2*j)/(j+1)/(2*j+3);
      end
   else 			% then n is even:
      m=n/2;
      c(n+1)=(-1)^m*factorial(n)/factorial(m)^2/2^n;
      for j=0:m-1		% assign monomial coefficients:
         c(n-1-2*j)=(j-m)*(2*j+n+1)*c(n+1-2*j)/(j+1)/(2*j+1);
      end
   end
   x=sort(roots(c))';
   w=legendre(n+1,x);
   w=2*(1-x).*(1+x)./((n+1)*w(1,:)).^2;
   if ~isreal(x)
      error(sprintf('ROOTS returned complex values for n=%d',n))
   end
   return
%
%  Test Legendre:
%
   n=8;
   [x w]=Gauss(n);
   for p=0:2*n
      t=(1+(-1)^p)/(1+p);	% true monomial integral
      disp(sprintf('Gauss-Legendre quadrature error=%9.2e',t-w*x'.^p))
   end
elseif strcmp(name,'Hermite')	% c of Hermite polynomial:
   if mod(n,2)			% then n is odd:
      m=(n-1)/2;
      c=[2^n zeros(1,m)];	% root poly in x^2:
      for j=2:m+1
         c(j)=c(j-1)*(m+2.5-j)*(m+2-j)/(1-j);
      end
      x=sqrt(roots(c));
      x=sort([-x
               0
               x])';
   else				% then n is even:
      m=n/2;
      c=[2^n zeros(1,m)];
      for j=2:m+1
         c(j)=c(j-1)*(m+1.5-j)*(m+2-j)/(1-j);
      end
      x=sqrt(roots(c));
      x=sort([-x
               x])';
   end
   w=Hermite(n-1,x,1);		% normalized polynomial
   w=1./(n*w(n,:).^2);		% Numerical Recipes (4.5.20)
   if ~isreal(x)
      error(sprintf('ROOTS returned complex values for n=%d',n))
   end
else
   error(['Not programmed for name==''' name ''''])
end
