function [nsds,ioffsets,filedesc,fmeta,smeta,iswap,stat] = gbin_fileinfo(filename)
%
% ROUTINE      : gbin_fileinfo (fournier)
% DESCRIPTION  : Gets GBIN-file level info
% DATE         : 2003/10/14
%
% [nsds ioffsets filedesc fmeta smeta iswap stat] = gbin_fileinfo(filename);
%
lun = fopen(filename);			% logical unit number
if lun==-1
   error(['File ' filename ' cannot be opened for reading'])
end
[filename permission machineformat] = fopen(lun);
if ~strcmp(permission,'r')
   error('Invalid GBIN file')
end
iswp = fread(lun,1,'int32');
iswap = 0;
if iswp~=1
  fclose(lun);
  lun  = fopen(filename,'r','ieee-be');
  if lun==-1
     error(['File ' filename ' cannot be opened for reading'])
  end
  [filename permission machineformat] = fopen(lun);
  if ~strcmp(permission,'r')
     error('Invalid GBIN file')
  end
  iswp = fread(lun,1,'int32');
  iswap = 1;
end
isize = fread(lun,1,'int32');
sisize = fread(lun,1,'int32');
fsize = fread(lun,1,'int32');
elemsize = fread(lun,1,'int32');
gfpossize = fread(lun,1,'int32');
idlen = fread(lun,1,'int32');
filedesc = char(transpose(fread(lun,idlen,'uchar')));
nmeta = fread(lun,1,'int32');
if nmeta>0
   fmeta = fread(lun,nmeta,'float64');
end
ilen = fread(lun,1,'int32');
if ilen>0
   smeta = char(transpose(fread(lun,ilen,'uchar')));
end
nsds = fread(lun,1,'int32');
if nsds>0
   ioffsets = fread(lun,nsds,'int64');
end
stat = 1;
fclose(lun);
