function [fileinfo,elems,u]=gbin_input(filename)
%
% [fileinfo elems u]=gbin_input(filename);
%
% Given input GBin type filename, return
% fileinfo (structure for file information),
% elems (structure for element mesh) and
% u (structure for scientific data on elems).
% To view a structure, e.g., "u", type "u<Enter>".
% Try "help meshelem" to view these data.
%
if strcmp(filename(end+(-3:0)),'.mat')
   load(filename)
else
   [nsds ioffsets filedesc fmeta smeta iswap stat] = gbin_fileinfo(filename);
   fileinfo=struct('nsds',nsds,'ioffsets',ioffsets,'filedesc',filedesc, ...
      'fmeta',fmeta,'smeta',smeta,'iswap',iswap,'stat',stat);
   vs = [];				% accumulate vert
   vis = [];				% accumulate vert & idims
   labs = {};				% accumulate labels
   nens = 0;				% no. unique element node sets (ENS)
%  b=0;
   for k=1:nsds				% loop over datasets
%     b=overWrite(b,sprintf('gbin_input %d of %d in %s',k,nsds,filename));
      [rank idims lab tags ntags dat x1 x2 vert nvert stat] ...
         = gbin_dsread(filename,ioffsets(k),iswap);
%     disp(sprintf('gbin_input: k=%d tags=%s',k,sprintf(' %d',tags)))
      v = struct2cell(vert);		% convert struct to cell
      vs = [vs
            v{:}];			% accumulate vert
      vi = [v{:} idims];		% 1 row w. 4 vertices & idims
      [t i] = ismember(vi,vis,'rows');	% test if vi already counted
      if ~i				% have not counted this ENS yet
         vis = [vis
                vi];			% count this ENS
         nens = nens+1;			% no. unique ENS
         i = nens;			% update i to point to ENS
         elems.x{i} = cat(3,x1,x2);	% concatenate so x{i}(:,:,p) is pth dim.
      end
      if ismember({lab},labs)		% field exists already
         eval(['j' lab '=j' lab '+1;'])	% increment counter
      else				% new field
         labs = {labs{:} lab};		% accumulate label
         eval(['j' lab '=1;'])		% counter for this label
      end
      eval(['u.' lab '{j' lab '}=dat;'])% assign data to appropriate name
      eval(['u.' lab 'ic(j' lab ')=i;'])% assign pointer to ENS
      if ntags>2			% assign element & element's parent keys
         eval(['u.' lab 'key(j' lab ')=tags(3);'])
         eval(['u.' lab 'pkey(j' lab ')=tags(4);'])
      end
   end
   elems.n = size(unique(vs,'rows'),1); 	% no. elements
end
