function h=manycall(filepat,call,domovie)
%
% h=manycall(filepat);
% h=manycall(filepat,call);
% F=manycall(filepat,call,domovie);
% F=manycall({fileinfo elems u},call,domovie);
%
% Given filepat, a string with a file specification
% pattern (including path and * wildcards) like 'abc*xyz',
% execute [fileinfo elems u]=gbin_input(filename); for every
% filename (labeled j) that matches filepat, and execute
% eval([call{1} 'elems,u,j,' call{2}]); for each j.
%
% If nargin<2 or call==[] use the default call={'h(j)=meshelem('
%                   '''V1'');view([40 60]),axis([0 1 0 1 b])'};
% where b contains the ZMIN ZMAX of the 1st call.
%
% If filepat is a structure than it is of mkfnames output type.
%
% If the 1st argument is a cell then loop over its columns' contents
% instead of using gbin_input.
%
% Use fig_flip(1:Nfigs,s) to cycle all figs at s seconds each.
%
% With "F=" variant (domovie a 3rd argin), save memory by
% overwriting figure j=1, but instead of h,
% return an array F of movie frames from getframe
% (that can be played using movie(1,F)),
% and if domovie=1 print each figure to a .png file named 'fig_abc*xyz.png'
% (with any subdirectory and 3-character extension info clipped)
% for later conversion using e.g., the unix command
%
% convert -delay 50 fig_abc*xyz.png abcxyz.mng
%
% If domovie is a string then it names a .avi animation file and no
% .png files are created.
%
if nargin<2 | isempty(call)	% assign default call:
   call={'h(j)=meshelem('
         '''V1'');view([40 60]),axis([0 1 0 1 b])'};
end
if nargin<3
   domovie=[];
end
if ischar(domovie)
   mov=['./' domovie '.avi'];
   if exist(mov,'file')
      clear mex
      delete(mov)
   end
   mov=avifile(domovie,'Compression','none','FPS',5);
end
if iscell(filepat)		% filepat contains data
   lt=length(filepat{3});	% length of field list
   if length(filepat{2})>1
      ei='(j)';			% possibly different elems for each j
   else
      ei='';			% same elems for each j
   end
   assig=['[fileinfo elems u]=deal(filepat{1}(j),filepat{2}' ei ',filepat{3}(j));'];
   p=datestr(now);		% date string for time==now
   z=strfind(call{2},'''');	% 1st 2 bracket field name
   for j=1:lt
      d(j)=struct('date',p,'name',...
         sprintf('%s%07d',call{2}(z(1)+1:z(2)-1),filepat{1}(j).fmeta(1)));
   end
elseif isstruct(filepat)	% filepat contains directory info
   d=filepat;			
   lt=length(d);		% length of time list
   warning('manycall:nread',sprintf('read %d files',lt))
   l=max(strfind(filepat(1).name,'/'));
   assig='f=[filepat(1).name(1:l) d(j).name];';
   assig=[assig 's=overWrite(s,sprintf(''processing %s, %d out of %d'',f,j,lt));'];
   assig=[assig '[fileinfo elems u]=gbin_input(f);'];
else				% filepat instructs gbin_input
   d=dir(filepat);
   lt=length(d);		% length of time list
   warning('manycall:nread',sprintf('read %d files',lt))
   l=max(strfind(filepat,'/'));	% isolate directory path
   assig='f=[filepat(1:l) d(j).name];';
   assig=[assig 's=overWrite(s,sprintf(''processing %s, %d out of %d'',f,j,lt));'];
   assig=[assig '[fileinfo elems u]=gbin_input(f);'];
end
if nargin>2
   ifig='1,';			% save memory by overwriting fig. 1
else
   ifig='j,';			% draw lt figures
end
if domovie==1			% then make .png files:
   ll=length(d(1).name);
   if d(1).name(ll-3)=='.'	% then clip extension:
      ll=1:ll-4;
   else
      ll=1:ll;
   end
end
b=[-1 1];			% ZMin, ZMax for 1st call
s=0;				% initialize overWrite
for j=1:lt			% loop over files
   eval(assig)			% assign [fileinfo elems u]
   eval([call{1} 'elems,u,' ifig call{2}]);
   meshtitl(fileinfo,elems,d(j))
   if j==1
      b=[Inf -Inf];		% initialize Zlim
      z=get(h(j).surf,'ZData');
      b=[min([b(1);z(:)]) max([b(2);z(:)])];
      set(gca,'ZLim',b)		% set Zlim
      t=get(gca,'Title');		% title text handle
      un=get(t,'Units');
      set(t,'Units','pixels');
      pt=get(t,'Extent');		% title extent in pixels
      set(t,'Units',un);		% restore default units
      p=get(1,'Position');		% figure position
      p([2 4])=p([2 4])+pt(4)*[-3 3];
      set(1,'Position',p);		% adjust for title height
   end
%  set(strread(ifig(1)),'Position',p)
   if nargin>2
      F(j)=getframe(1);
      if ischar(domovie)
	mov = addframe(mov,F(j));
      elseif domovie==1
         imwrite(frame2im(F(j)),['fig_' d(j).name(ll) '.png'])
      end
   end
end
if nargin>2
   h=F;
   if ischar(domovie)
      mov = close(mov);
   end
end
