function nodeerr=mesh_t(filepat)
%
% nodeerr=mesh_t(filepat);
%
% With no input argument, test mesh_t.csh results by
% reading filepat='results.*.000000'.  Otherwise read
% files matching the string pattern filepat.
% Return nodeerr{1:nfiles}(1:2,1:nelems), the relative node
% location error for all files, both dimensions, all elements.
%
if nargin<1
   filepat='results.*.000000';
end
d=dir(filepat);			% collect output files
nf=length(d);			% no. files
for n=1:nf			% loop over files:
   [fileinfo elems u]=gbin_input(d(n).name);
   for k=1:elems.n		% loop over elements:
      [nx ny]=size(u.V1{k});	% expansion sizes
      ox=ones(nx,1);
      oy=ones(1,ny);
      j=u.V1ic(k);		% index to coordinates
      a=elems.x{j}([1 nx],1,1);	% x limits of element k
      b=elems.x{j}(1,[1 ny],2);	% y limits of element k
      xi1=a(1)+.5*(a(2)-a(1))*(GausLoba(nx-1)'+1);
      xi2=b(1)+.5*(b(2)-b(1))*(GausLoba(ny-1) +1);
      nodeerr{n}(1,k)=norm(elems.x{j}(:,:,1)-xi1*oy)/norm(elems.x{j}(:,:,1));
      nodeerr{n}(2,k)=norm(elems.x{j}(:,:,2)-ox*xi2)/norm(elems.x{j}(:,:,2));
%     disp(sprintf('File %s, element %d, (px,py)=(%d,%d), node errs=(%9.3g,%9.3g)',...
%        d(n).name,k-1,nx-1,ny-1,...
%        norm(elems.x{j}(:,:,1)-xi1*oy)/norm(elems.x{j}(:,:,1)),...
%        norm(elems.x{j}(:,:,2)-ox*xi2)/norm(elems.x{j}(:,:,2))))
   end
end
