function [ustat,time]=mtseries(filepat,lab,fi,sliceid)
%
% [ustat time]=mtseries(filepat,'lab');
% [ustat time]=mtseries(filepat,'lab','f(time,x)');
% [ustat time]=mtseries(filepat,'lab',[val dim]);
% [ustat time]=mtseries(filepat,'lab','f(time,x)',[val dim]);
%
% Given filepat, a string with a file specification
% pattern (including path and * wildcards) like 'abc*xyz',
% files containing time sequence of spatial solutions,
% return time vector time(1:lt) and spatial statistics ustat(1:lt)
% (do "help statelem") of field labeled 'lab'.
% For example "plot(time,[ustat.ummax])" plots the max-magnitude.
%
% If nargin>2 then pass 'f(time,x)' to statelem; or return
% ustat(1:lt).uslice containing samples of 'lab' along coordinates
% elems.x{j}(:,:,dim)==val returned in ustat(1:lt).xory; or do both.
%
% For 'f(time,x)' pass an expression string like
%  'sin(pi*(x(:,:,1)+2*x(:,:,2)-time))' or
%  'BurgersH(  1e-3         ,time,x,50,0,0,[1 2])' or (more accurately)
% ['BurgersH(' mat2str(nu) ',time,x,50,0,0,[1 2])']
% where nu has a value in the calling workspace.
%
if nargin>2
   if ischar(fi)
      fif=true;			% inline function flag
      slf=false;		% slice flag
      jt=strfind(fi,'time');	% start indexes of 'time'
      w=fi(1:jt(1)-1);		%
      for i=1:length(jt)-1
         w=[w '%s' fi(jt(i)+4:jt(i+1)-1)];
      end
      w=[w '%s' fi(jt(end)+4:end)];
      jt=ones(1,length(jt));
   else
      sliceid=fi;
      clear fi
      fif=false;		% inline function flag
      slf=true;			% slice flag
   end
end
if nargin>3
   slf=true;			% slice flag
end
d=dir(filepat);			% get output filenames
lt=length(d);			% length of time list
if ~lt
   error(sprintf('dir(%s) returns %d files',filepat,lt))
end
time=zeros(lt,1);		% allocate time vector
l=max(strfind(filepat,'/'));	% isolate directory path
b=0;				% initialize overWrite
for k=1:lt			% loop over files
   f=[filepat(1:l) d(k).name];	% filename
   [fileinfo elems u]=gbin_input(f);
   b=overWrite(b,sprintf('mtseries finds %d elements in %s, %d of %d files',elems.n,f,k,lt));
   time(k)=fileinfo.fmeta(11);	% time value
   if fif			% use inline function fi:
      ts={mat2str(time(k))};	% string of time value
      ts=sprintf(w,ts{jt});	% print ts into each 'time'
      ustat(k)=statelem(elems,u,lab,ts);
   else
      ustat(k)=statelem(elems,u,lab);
   end
   if slf			% do slices:
      ustat(k).uslice=[];	% initialize slice
      ustat(k).xory=[];		% initialize slice coordinates
   end
   for i=1:elems.n		% loop over elements
      j=eval(['u.' lab 'ic(i)']);
      ui=eval(['u.' lab '{i}']);% ui='lab' in element i
      if slf			% do slices:
         if sliceid(2)==1	% slice for x=sliceid(1):
            p=find(elems.x{j}(:,1,1)==sliceid(1));
            if ~isempty(p)
               z=ui(p,:);
               ustat(k).uslice=[ustat(k).uslice
                                z(:)];
               z=elems.x{j}(p,:,2);
               ustat(k).xory=[ustat(k).xory
                              z(:)];
            end
         else			% slice for y=sliceid(1):
            p=find(elems.x{j}(1,:,2)==sliceid(1));
            if ~isempty(p)
               z=ui(:,p);
               ustat(k).uslice=[ustat(k).uslice
                                z(:)];
               z=elems.x{j}(:,p,1);
               ustat(k).xory=[ustat(k).xory
                              z(:)];
            end
         end
         [ustat(k).xory p]=sort(ustat(k).xory);
         ustat(k).uslice=ustat(k).uslice(p);
      end
   end				% i loop
end				% k loop
fprintf('\n')			% finish overWrite
