function [z1,z2,ke]=perNWave(x,y1,y2,c,t)
%
% function u=perNWave(x,y,c,t);
% function u=perNWave(elems,V,c,t);
%
% u = periodized NWave solution in both directions:
%
% u(t,x,y) = sum sum x/t [1+sqrt(t/c(3)) *[exp[(k_x (x-c(1))+2PI*i)^2/(4 c(4) t) + (k_y(y-c(2))+2PI*i)^2/ (4 c(3) t) ] / g(R0) ] ^-1
%            -oo -oo
%
% where 
%             g(R0) = exp(R0) - 1.
%
% If (x,y) are passed they're assumed to have uniform meshgrid-type shapes.
% If (elems,V) are passed they correspond to typical elems structure and u.V1 field,
% and u has fields u.Va, u.Vaic, u.Verr=u.Va-V and u.Verric.
%
% c(1) in [0,1] is the x-location of the peak (default .5),
% c(2) in [0,1] is the y-location of the peak (default .5),
% c(3) is the initial profile time, t0>0 (default 1).
% c(4) is the diffusivity nu (default 1e-3) if t>0.
% c(5) is the Reynolds number, R0 (default 100).
%
% If t>t0 then return solution from t=t0 i.c. of
%
% u  = (nu div grad - u.grad)u
%
% Calling example:
%   [u1,u2]=perNWave(elem,u.V1,u.V2,[.5 .5 1 nu 100],t);

% 
eps = 1e-18;
if nargin<4|isempty(c)
   c=[.5 .5 1 1e-4 100];
end
if nargin<5
   t=c(3);				% initial condition
end
%c([1 3])=k([1 3])+eval(expr);
if isstruct(x)			% x is the structure elems
   flag=1;
   nelem=x.n;			% no. elements
   x=x.x;
else				% x & y are meshgrid-style
   flag=0;
   nelem=1;			% one element
   x={cat(3,x,y1)};		% imitate element structure
end
t0     = c(3);
R0     = c(5);
nufact = 1.0/( 4*c(4)*t );
rfact  = 1.0 / ( exp(R0) - 1);
tfact  = sqrt(t/t0);
k      = [2*pi 2*pi];
for i=1:nelem			% loop over number elements
   p{1}=x{i}(:,:,1)-c(1);	% shift x by x0
   p{2}=x{i}(:,:,2)-c(2);	% shift y by y0 
   zer=zeros(size(p{1}));		% assume correct x size
   one =ones(size(p{1}));		% assume correct x size
   z1=zer;
   z2=zer;
   dz1=one;
   dz2=one;
   m=1;
   n=1;
   xpp = k(1).*p{1};
   ypp = k(2).*p{2};
   argp   = (xpp.^2+ypp.^2) .* nufact;    
   gfactp = 1.0./( t .* ( 1.0 + ( (tfact*rfact) .* exp(argp) ) ) );  
   z1    = gfactp.*xpp;
   z2    = gfactp.*ypp;
   while max(abs(dz1(:)))>eps*max(abs(z1(:))) && max(abs(dz2(:)))>eps*max(abs(z2(:)))
     ypp = k(2).*p{2}+2*pi*n;
     ypm = k(2).*p{2}-2*pi*n;
     while max(abs(dz1(:)))>eps*max(abs(z1(:))) && max(abs(dz2(:)))>eps*max(abs(z2(:)))
       xpp    = k(1).*p{1}+2*pi*m;
       xpm    = k(1).*p{1}-2*pi*m;
       argp   = (xpp.^2+ypp.^2) .* nufact;    
       argm   = (xpm.^2+ypm.^2) .* nufact;    
       gfactp = 1.0./( t .* ( 1 + ( (tfact*rfact) .* (exp(argp)) ) ) );  
       gfactm = 1.0./( t .* ( 1 + ( (tfact*rfact) .* (exp(argm)) ) ) );  
       dz1  = xpp.*gfactp + xpm.*gfactm;
       dz2  = ypp.*gfactp + ypm.*gfactm;
       z1   = z1 + dz1;
       z2   = z2 + dz2;
       m=m+1;
     end
     n=n+1;
   end

%  disp(sprintf('Element %d max shift: (%d,%d)',i-1,nit))
   z1(find(isnan(z1(:))))=0;		% eliminate NaN values
   z2(find(isnan(z2(:))))=0;		% eliminate NaN values
   if flag
      u1.Va{i}=z1(:,:,1);
      u1.Vaic(i)=i;
      u1.Verr{i}=u1.Va{i}-y1{i};		% error field
      u1.Verric(i)=i;
      u2.Va{i}=z2(:,:,1);
      u2.Vaic(i)=i;
      u2.Verr{i}=u2.Va{i}-y2{i};		% error field
      u2.Verric(i)=i;
      ke.Va{i}=z2(:,:,1)^2 + z1(:,:,1)^2;
      ke.Vaic(i)=i;
      ke.Verr{i}=ke.Va{i}-(y1{i}^2+y2{i}^2);		% error field
      ke.Verric(i)=i;
   end
end
if flag
   z1=u1;
   z2=u2;
end
