function z1=perPlanarNWave(x,y1,c,t)
%
% function u=perPlanarNWave(x,y,c,t);
% function u=perPlanarNWave(elems,V,c,t);
%
% u = periodized NWave solution in x-direction:
%
%             oo
% u(t,x,y) = sum (x-iL)/t [exp[-(x-c(1))+iL)^2/(4 nu t) ] /
%            i=-oo
%             oo
%            sum [exp[-(x-c(1))+iL)^2/(4 nu t) ]
%            i=-oo
%
%
% If (x,y) are passed they're assumed to have uniform meshgrid-type shapes.
% If (elems,V) are passed they correspond to typical elems structure and u.V1 field,
% and u has fields u.Va, u.Vaic, u.Verr=u.Va-V and u.Verric.
%
% c(1) in [0,1] is the x-location of the peak (default .5),
% c(2) in [0,1] is the y-location of the peak (default .5),
% c(3) is the diffusivity nu (default 1e-2), 
% c(4) is the periodicity length (default 1).
%
% Calling example:
%   u1=perPlanarNWave(elem,u.V1,[0.5 0.5 nu 1],t);

% 
eps = 1e-18;
if nargin<3|isempty(c)
   c=[.0 .0 1e-2 1];
end
if nargin<4
   t=1;                         % initial condition
end
if isstruct(x)			% x is the structure elems
   flag=1;
   nelem=x.n;			% no. elements
   x=x.x;
else				% x & y are meshgrid-style
   flag=0;
   nelem=1;			% one element
   x={cat(3,x,y1)};		% imitate element structure
end
nu = c(3);
Lx = c(4);
nufact = 1.0/( 4*nu*t );
k      = [2*pi 2*pi];
tinv   = 1.0 / t;
for i=1:nelem			% loop over number elements
   p{1}=x{i}(:,:,1)-c(1);	% shift x by x0
   p{2}=x{i}(:,:,2)-c(2);	% shift y by y0 
   zer=zeros(size(p{1}));       % assume correct x size
   one =ones(size(p{1}));       % assume correct x size
   m=1;
   xpp = p{1};
   argp   = (xpp.^2) * (-nufact);    
   gfactp = exp(argp);
   num    = gfactp .* xpp * tinv;
   den    = gfactp ;
   dnum    = one;
   dden    = one;
   while max(abs(dnum(:)))>eps*max(abs(num(:))) || max(abs(dden(:)))>eps*max(abs(den(:))) 
     xpp    = p{1}+m*Lx;
     xpm    = p{1}-m*Lx;
     argp   = (xpp.^2) * (-nufact);    
     argm   = (xpm.^2) * (-nufact);    
     gfactp = exp(argp);  
     gfactm = exp(argm);  
     dnum   = xpp.*gfactp * tinv + xpm.*gfactm * tinv;
     dden   =      gfactp        +      gfactm       ;
     num    = num + dnum;
     den    = den + dden;
     m=m+1;
   end
   z1     = num ./ den;
%  disp(sprintf('Element %d max shift: (%d,%d)',i-1,nit))
   z1(find(isnan(z1(:))))=0;		% eliminate NaN values
   if flag
      u1.Va{i}=z1(:,:,1);
      u1.Vaic(i)=i;
      u1.Verr{i}=u1.Va{i}-y1{i};		% error field
      u1.Verric(i)=i;
   end
end
if flag
   z1=u1;
end
