function [h,A,labs]=plotlogf(fname,icols,jcols,pars,pltflag,nbackup,llist)
%
% [h A labs]=plotlogf('fname',icols,jcols,'pars',pltflag,nbackup,llist);
%  h     =plotlogf({A labs},icols,jcols,'pars',pltflag,nbackup,llist);
%
% Read data matrix A from file 'fname' and return handle h from
% eval(['h=plot(A(:,icols),A(:,jcols)' 'pars' ');']) and cell
% array labs of legend strings.  In 'fname'
% lines starting with '#' are ignored, lines starting with ' ',
% '!*' or a digit are read for equal numbers of numeric data columns.
%   
% Defaults:
%    'fname'	'test_log.txt'
%    icols	2		time column
%    jcols	9		dU1/dx_max
%    'pars'	[]		e.g., ',''r--''' for red dashed
%    pltflag    true            do plot
%    nbackup	1		backup to labels line before data
%    llist	'1:ndl'		line number range to read
%
% If 'fname' contains a '*' (no directory path allowed) then
% loop over the wildcard-expanded file list, and automatically
% assign pars for each file and each data column.
%
% Once A & labs have been returned you can enter them to avoid rereading fname.
%
persistent d prs
if nargin<1|isempty(fname)
   fname='test_log.txt';		% input file name
end
if nargin<2|isempty(icols)
   icols=2;				% x-axis variable
end
if length(icols)>1
   warning('PLOTLOGF:icols','XLABEL gets element 1 of %d in icols',length(icols))
end
if nargin<3|isempty(jcols)
   jcols=9;				% y-axis variable
end
ncol=length(jcols);
if nargin<4|isempty(pars)		% plot parameters:
   pars=',[c(1+mod(i-1,nc)) s{1+mod(j-1,ns)}]';
end
if nargin<5|isempty(pltflag)
   pltflag=true;			% plot flag
end
if nargin<6|isempty(nbackup)
   nbackup=1;				% labels before data
end
if nargin<7
   llist='1:ndl';
end
h=[];					% initialize plot handle
b={};					% initialize legend box
c='bgrcmk';				% line colors
nc=length(c);
s={'-' '--' '-.' ':'};			% line styles
ns=length(s);
if ischar(fname)
   if ~isempty(strfind(fname,'*'))	% if there's a wildcard:
      d=dir(fname);			% get log filenames
      ll=length(d);			% list length
   else
      d.name=fname;			% name without path
      ll=1;				% just one log file
   end
   prs=pars;
else
   ll=prod(size(fname{1}));
end
for i=1:ll				% loop over files
   fi=d(i).name;			% current file
   fie=insescape(fi);			% insert '\' ahead of underscore
   if ischar(fname)
      F=textread(fi,'%s','delimiter','\n');
      nlines=length(F);			% no. lines in input file
      ndl=nlines;			% no. data lines
      for l=1:nlines			% loop over F rows
%        disp([l length(F{l})])		% for debugging
         if badline(F{l})
            ndl=ndl-1;			% ignore bad lines
         end
      end
      rlist=eval(llist);		% list of lines to read
      nrl=length(rlist);		% no. read lines
      ndl=min(ndl,nrl);			% no. data lines
      disp(sprintf('Read %d out of %d lines in file %s',ndl,nlines,fi))
      for l=1:nlines			% loop over F rows
         if ~badline(F{l})		% ndc = no. data columns:
            ndc=length(eval(['[' F{l} ']']));
            break			% assume fixed ndc for all lines
         end
      end
      labs=strread(F{l-nbackup}(2:end),'%s');
      labs=insescape(labs);		% insert '\' ahead of underscore
      A{i}=nan(ndl,ndc);
      m=1;
      for k=l:nlines			% loop over F rows
         if ~badline(F{k})
%           disp([k eval(['[' F{k} ']'])])
            A{i}(m,:)=eval(['[' F{k} ']']);
            m=m+1;
         end
      end
   else
      A{i}=fname{1}{i};
      labs={fname{2}{:}};
   end
   for j=1:ncol
      b={b{:} [fie ':' labs{jcols(j)}]};
   end
   if pltflag
      for j=1:ncol
         eval(['h=[h;plot(A{i}(:,icols),A{i}(:,jcols(j))' prs ')];'])
         if j==1
            hold on
         end
      end
   end
end
hold off
if pltflag
   legend(h,b,0)
  xlabel(labs{icols(1)})
end

function B=badline(Fl)
B=length(Fl);				% true if Fl not empty
if B					% if Fl empty:
   B=(Fl(1)=='#');
end
