function z = siLorent(x,y,k,t,expr)
%
% function u=siLorent(x,y,k,t,expr);
% function u=siLorent(elems,V,k,t,expr);
%
% u = symmetric imbricated Lorentzians in both directions
%
% If (x,y) are passed they're assumed to have uniform meshgrid-type shapes.
% If (elems,V) are passed they correspond to typical elems structure and u.V1 field,
% and u has fields u.Va, u.Vaic, u.Verr=u.Va-V and u.Verric.
%
% k(1) in [0,1] is the x-location of the peak,
% k(2) in ]0,1[ is x-width ~(1-k(2)) and height 2*csch|ln k(2)|
% k(3) in [0,1] is the y-location of the peak,
% k(4) in ]0,1[ is like k(2) in the y-direction,
% k(5) in integers is an x-wavenumber,
% k(6) in integers is a y-wavenumber, and
% k(7) is the diffusivity nu (default 1e-2) if t>0.
%
% If t>0 then return solution from t=0 i.c. of
%
% u  = (nu div grad - c(t).grad)u
%  t
%
% where c(t)=dr/dt and r(t) is given by the string
% expr (default '.25*[sin(t),-cos(t)]').
% If t=0 expr still modifies the (k1,k3) location.
% 
if length(k)<7
   k(7)=1e-2;				% diffusivity nu
end
if nargin<4
   t=0;					% initial condition
end
if nargin<5
   expr='.25*[sin(t),-cos(t)]';
end
f=2*pi*k(5);				% x wavenumber
g=2*pi*k(6);				% y wavenumber
k([1 3])=k([1 3])+eval(expr);
%disp(k([1 3]))
if isstruct(x)				% x is the structure elems
   flag=1;
   nelem=x.n;				% no. elements
   x=x.x;
else
   flag=0;
   nelem=1;
   x={cat(3,x,y)};
end
for i=1:nelem				% loop over number elements
   [p{1} p{2}]=wave_rot(x{i}(:,:,1)-k(1),x{i}(:,:,2)-k(3),f,g);
   if t==0				% initial condition
      [a b c]=par2abc(k(2),k(4));
      [r s]=bcxy2rs(b,c,p{1},p{2});	% Lorentzian factors
      z=r.*s*a;				% Lorentzian function
%
%     ... its x- & y-derivatives:
%
      z=cat(3,z,(g*sin(p{2}).*s-f*sin(p{1}).*r).*z);
      z=cat(3,z,-(f*sin(p{2}).*s+g*sin(p{1}).*r).*z(:,:,1));
   else
      b=exp(-4*pi^2*k(7)*t);
      c=b^2;
      o=ones(size(x{i}(:,:,1)));	% assume correct x size
      z=o;
      for l=1:2				% loop over spatial directions
         w=o;
         dz=Inf;
         n=1;				% wavenumber
         q=k(2*l);			% kx or ky
         a=q;				% q^n factor
         r=b;				% exp(-t*n^2)
         s=c;				% exp(-t*2*n)
         while max(abs(dz(:)))>eps*norm(w)
            dz=2*a*r*cos(n*p{l});
            w=w+dz;
            r=r*s*b;			% exp(-t*n^2)
            s=s*c;			% exp(-t*2*n)
            n=n+1;			% wavenumber
            a=a*q;			% q^n factor
         end
         z=z.*w;
%        nit(l)=n-1;			% no. iterations
      end
%     disp(sprintf('Element %d max wavenumber: (%d,%d)',i-1,nit))
   end
   if flag
      u.Va{i}=z(:,:,1);
      u.Vaic(i)=i;
      u.Verr{i}=u.Va{i}-y{i};
      u.Verric(i)=i;
   end
end
if flag
   z=u;
end

function [a,b,c]=par2abc(kx,ky)
a=((1-kx^2)/(2*kx)) ...
 *((1-ky^2)/(2*ky));				% a = sinh|ln kx|*sinh|ln ky|
b=((1+kx^2)/(2*kx));				% b = cosh|ln kx|
c=((1+ky^2)/(2*ky));				% c = cosh|ln ky|

function [p,q]=wave_rot(x,y,f,g)		% "Rotate" x, y by
p=f*x+g*y;					% [ f g
q=f*y-g*x;					%  -g f]

function [r,s]=bcxy2rs(b,c,p,q)
r=1./(b-cos(p));
s=1./(c-cos(q));
