//======================================================================================
// Name         : gdd.cpp
// Date         : 9/06/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Driver for grid partitioning preprocessor. 
//                We will want to provide an interface directly
//                to this main, so that we can use it in
//                direct calls, if required.
// Modifications:
//======================================================================================

#include "gdd_file.h"

// Defines:
#define SOHANDLE        void *
#define SYMADDRESS      void *


// Global data:
char   *cversiono_    = "0.1";
GDD_FILE_TYPE filetype_   = FT_BYPROC;
GINT     nd_           = 2;
GINT     nproc_        = 1;
GINT     nelem_    [3] = {1,1,1};
GINT     totalelem_    = 1;
GLONG    nnodes_   [3] = {4,4,4};
GINT     bPeriodic_[3] = {FALSE};
GINT     nBdyCond_     = 0;
GINT     ncorner_set_  = 0;
GINT     icorner_set_[8]={-1};
GBOOL    bQuiet_       = FALSE;
GBOOL    bPartLib_     = FALSE;
GBOOL    bDoNodeIDs_   = FALSE;
GFLOAT   P0_       [3] = {0.0,0.0,0.0};
GFLOAT   P1_       [3] = {1.0,1.0,1.0};
GFLOAT   B0_    [6][3] = {0.0};           
GFLOAT   B1_    [6][3] = {0.0};             
BDYTYPE  btype_    [6] = {NONE};
BDYTYPE  corner_bc_[8] = {NONE};
//Point3D *pV_          = NULL;
char     fname_    [FILE_NAME_MAX] = "mesh.dat";
char     partlib_  [FILE_NAME_MAX];
DD_Rect *dd           = NULL;;

char *tokeol      = ";";
char *toklist     = ":";
char *toklev1_2[] = {"{","}"};
char *toklev2_2[] = {"(",")"};
char *sfiletypes_[] = {"By_Proc", "By_Elem"};


// Function declarations:
GBOOL        Parse(GINT argc, char *argv[]);
void         Echo (ostream &);
GBOOL        DoCyclicDist();       
GBOOL        DoSODist();       
GBOOL        WriteByProc();       
GBOOL        WriteByElem();       
void         PrtHelp(GINT  argc, char **argv, ostream &);
SOHANDLE     so_open(const char *filename);
void         so_close(SOHANDLE);
SYMADDRESS   so_sym (SOHANDLE handle, const char *filename);
const char  *so_error(void);


