//************************************************************************************//
// Module       : apost_rror.hpp
// Date         : 6/4/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the object providing a-posteriori error estimates for
//                the state (field). The object uses primarily the methods detailed
//                in C. Mavriplis' Ph.D. dissertation.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(APOST_ERROR)
#define APOST_ERROR

#include "field2d.hpp"
#include "mtk.hpp"
#include "gtbuffer.hpp"
#include "gtmatbuffer.hpp"

class APostError
{
public:

         enum  GERR_NORM   {EN_L2, EN_H1_SEMI};
         enum  GEXT_FUNC   {FF_EXP, FF_POWER_LAW};
                           APostError(GERR_NORM norm, Field2D *fld=NULL);
                          ~APostError();

         void              SetField(Field2D *fld);                            // Set field whose error is desired
         void              SetNumFitPoints(GINT  idir, GINT  num);            // Set number of fit points in each dir
         void              SetNumFitPoints(GINT  num);                        // Set number of fit points in both dirs
         void              SetExtrapFunc(GEXT_FUNC functype);                 // Set extrapolation function type
         void              SetMinNumFitPoints(GINT  n);                       // Set minimum no. of fit points for good fit
         void              SetTiny(GDOUBLE c);                                  // Set size of smallest significant coeff
         GBOOL             ComputeErrEst();                                   // Compute error estimate
         GDOUBLE           GetErrEst();                                       // Get total error estimate
         GDOUBLE           GetErrEst(GINT  idir);                             // Get error estimate for direction idir
         GDOUBLE           *GetEnergySpectrum(GINT  &num);                    // Get 'Energy' spectrum/repres. of error
         GBOOL             isDecaying(GINT  idir);                           // Is spectrum decaying?
         GDOUBLE           GetMaxDecayRate();                                // Get max decay rates
         GVector          *GetDecayRate();                                   // Get fit params: decay rates
         GVector          *GetIntercept();                                   // Get fit params: intercepts
         GVector          *GetQFit     ();                                   // Get fit quality measure
         GVector          *GetLegendre(GINT icomp) ;                         // Get Leg. expansion coeffs
         GBOOL             ComputeLegendreCoeffs();
         GINT              NumberNormComps();                                // Get # norm comps


private:
         // Methods:
         GBOOL             ComputeTruncError();
         GBOOL             DoFit();
         GBOOL             ComputeExtrapError();
//       GBOOL             FindNonZero();
         void              SetParams();
         void              LinFit(GDOUBLE &slope, GDOUBLE &intcp, GDOUBLE &qfit,
                                  GDOUBLE x[], GDOUBLE y[], GINT  n);

         // Member data:
         GBOOL             bAvg_;
         GINT              num_fit_pts_[GDIM];
         GINT              nfit_min_;
         GINT              NN_[GDIM];
         GINT              itot_;
         GINT              nCoeffs_;
         GBOOL             isDecaying_[GDIM];
         GDOUBLE           ctiny_;
         GDOUBLE           error_est_[GDIM];
         GDOUBLE           error_trunc_[GDIM];
         GDOUBLE           error_extrp_[GDIM];
         GDOUBLE           *x_;
         GDOUBLE           *y_;
         GERR_NORM         inorm_type_;
         GEXT_FUNC         ifit_func_;
         GEXT_FUNC         iext_mthd_;
         Field2D           *field_;
         GNBasis           *basis_[GDIM];
         GVector           Coeffs_[GDIM][GDIM];
         GVector           sigma_[GDIM];
         GVector           intcp_[GDIM];
         GVector           qfit_[GDIM];
         GVector           *du_[GDIM];
         GVector           *int_[GDIM];
         GMatrix           Lp_[GDIM];
};

#endif
