//************************************************************************************//
// Module       : defquad2d.hpp
// Date         : 9/14/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a single deformed quadrilateral Cartesian 2D spectral 
//                element comprised only of straight-line segments.
//                The following is the ordering for the vertices (Vi)
//                and segment midpoints (Mi):
//
//          V7 ________________ V6
//            /|     M6       /|
//       M7  / |             / |
//          /  |        M5  /  |
//         /M11|  M4       /   |
//     V4 /____|___ ______/    | M10
//        |    |         | V5  |
//        |    |     M2  |     |
//        | V3 |_________|_____| V2
//    M8  |    /         |    /
//        |   /       M9 |   /
//        |  / M3        |  / M1
//        | /            | /
//        |______________|/
//       V0       M0     V1
//
// [Note that in 2d, we use just the bottom plane.]

// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(DEFQUAD2D_HPP)
#define DEFQUAD2D_HPP
#include "elem2d.hpp"

class DefQuad2D : public Elem2D
{
public:
                 DefQuad2D(GSHORT ntmp=2);
                 DefQuad2D(GINT  n1, GINT  n2, GSHORT ntmp=2 );
                 DefQuad2D(GNBasis *b1, GNBasis *b2, GSHORT ntmp=2 );
                 ~DefQuad2D();
void             operator=(const DefQuad2D &);
                   
//GINT             GetOrder(const GINT  idir);
GDOUBLE            Integrate(GVector *v, GDOUBLE *multiplicity=NULL);
GDOUBLE            PIntegrate(GVector *v, GDOUBLE *multiplicity=NULL);
GBOOL            Differentiate(GVector *dv, GVector *v, GINT  idir);
GBOOL            DifferentiateWithMass(GVector *dv, GVector *v, GVector* tmp, GINT  idir);
GBOOL            DifferentiateWeak(GVector *dv, GVector *v,GVector* tmp, GINT  idir);
GBOOL            Assemble();
GNBasis         *GetBasisObj(GINT  idir);
GVector         *GetXiNodes(GINT  idir); 
GVector         *Get1DWeights(GINT  idir);
GMatrix         *Get1DDerivMatrix(GINT  idir, GBOOL bTranspose);  
GMatrix         *Get1DStiffMatrix(GINT  idir, GBOOL bTranspose);             
GMatrix         *Get1DDerivMatrixWithMass(GINT  idir, GBOOL bTranspose);  
GMatrix         *Get1DDerivMatrixWeak(GINT  idir, GBOOL bTranspose);  
GVector         *Get2DWeights();                              
GVector         *GetJacobian();                              
GVector         *GetMassMatrix();                           
GVector         *GetiMass();                           
GVector         *GetgMass();                           
#if 0
GDOUBLE           &TensorD1(GINT  i, GINT  j);                           
GDOUBLE           &TensorD2(GINT  i, GINT  j);                           
#endif
GVector         *GetSpNodes(GINT  idir);                  
GVector         *GetdXidX(GVector **, GINT  );          
GVector         *GetdXidX   (const GINT  i, const GINT  j ); 
GVector         *GetMetric  (const GINT  i, const GINT  j ); 
GVector         *GetWJMetric(const GINT  i, const GINT  j ); 
GMatrix         *GetInterpOp(GINT  idir, GBOOL Transpose);
GMatrix         *GetInterpDeriv(GINT  idir, GBOOL Transpose);


GBOOL             XToXi(Point3D pX[], Point3D pXi[], const GINT  n);
//GMatrix        *GetBasisAtXi(GINT  i, GINT  j, GMatrix *B); 


GBOOL             ComputeSpNodes();
GBOOL             ComputeLaplacian();
GBOOL             SetVertices(Point3D P[], GINT  num);
//void              SetBasis(GNBasis *b1, GNBasis *b2);
//void              SetBasis(GNBasis *b, GINT  idir);
//void              SetOrder(GINT  iorder1, GINT  iorder2);
void              SetInterpBasis(GNBasis *b1, GNBasis *b2);
GBOOL             Resize(GINT  order1, GINT  order2);
GINT              SolveFE();


protected:

GDOUBLE          fRet;
GVector        *xiNodes1;
GVector        *xiNodes2;
GVector        *Weights1;
GVector        *Weights2;
GVector        *Weights2D;
GVector        *MassMatrix;
GVector        *gMassMatrix;
GVector        *iMassMatrix;
GMatrix        *StiffMat1;
GMatrix        *StiffMat2;
GMatrix        *StiffMat1T;
GMatrix        *StiffMat2T;
GMatrix        *D1;
GMatrix        *D2;
GMatrix        *D1T;
GMatrix        *D2T;
GMatrix        *opInterp1;
GMatrix        *opInterp2;
GMatrix        *opInterpT1;
GMatrix        *opInterpT2;
GMatrix        *dInterp1;
GMatrix        *dInterp2;
GMatrix        *dInterpT1;
GMatrix        *dInterpT2;
GVector        *Jac;
GVector        *d11;
GVector        *d12;
GVector        *d21;
GVector        *d22;
GVector        *g11;
GVector        *g12;
GVector        *g22;
GVector        *gWJ11;
GVector        *gWJ12;
GVector        *gWJ22;
GDOUBLE          *xi1p;
GDOUBLE          *xi1m;
GDOUBLE          *xi2p;
GDOUBLE          *xi2m;

private:

// Private methods:
GBOOL             Initialize(GINT  order1, GINT  order2);
void              DeleteDynamic();
GBOOL             ComputeGeo();

// Private data:


};


#endif
