//************************************************************************************//
// Module       : gstepper.hpp
// Date         : 6/24/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a stepper interface class. This is intended to serve as a
//                (minimum) template for other time stepper objects.
// Derived From : none.
// Modifications: none.
//************************************************************************************//
#if !defined(GSTEPPER_HPP)
#define GSTEPPER_HPP

#include "cg.hpp"
#include "gcomm.hpp"
#include "gelemlist.hpp"
#include "gfieldlist.hpp"

class GStepper
{
public:

                                   GStepper(){};
                                   GStepper(GElemList *elems){};
                                   GStepper(GElemList *elems, GFieldList *ulist[], GINT  nlist,
                                            GFieldList **cadv, GINT  *iadv, GINT  nadv){};
                                   GStepper(GFieldList *ulist[], GINT nf, GElemList *uelems, 
                                            GElemList *pelems, GINT t){};

                                  ~GStepper(){};

         virtual GBOOL             Step(GDOUBLE dt)=0;                                              // Take one time step
         virtual void              SetComm(GS *ggs)=0;                                              // Set global gather scatter operator
         virtual GCHandle          SetCommHandle(GCHandle hIn)=0 ;                                  // Initializes comm with existing handle 
         virtual void              SetVBdyData (GINT  idir, GVecList *bdy_vals)=0;                  // Set bcs for component idir
         virtual void              SetTimestepHistory(GDBuffer *dthist)=0;                          // Set timestep hist. buffer

//       virtual CG                *GetSolver(GINT  idir)=0;                                        // Get pointer to iterative solver
//       virtual LinOp            *GetPreconditioner(GINT  idir, GINT  eid)=0;                      // Get preconditioner for component idir, element eid
//       virtual GINT              GetNumIterations(GINT  idir)=0;                                  // Get no. solver iterations
//       virtual GINT              GetErrorType(GINT  idir)=0;                                      // Get solver error type
//       virtual GDOUBLE           GetError(GINT  idir)=0;                                          // Get solver error
//       virtual GDOUBLE           GetMinError(GINT  idir)=0;                                       // Get solver min error
//       virtual GDOUBLE           GetMaxError(GINT  idir)=0;                                       // Get solver max error
//       virtual void              SetElemList(GElemList *elems)=0;                                 // Set element list
//       virtual void              SetEvolType(TIME_EVOLTYPE itype)=0;                              // Set time stepping scheme
         virtual void              SetTime(GDOUBLE time)=0;                                         // Set integration start time
//       virtual void              SetNSubcycles(GINT nsub)=0;                                      // Set number of OIFS subcycles
//       virtual void              SetPreconditioner(GINT  idir, GPC itype)=0;                      // Set preconditioners

private:
};

#endif
