//************************************************************************************//
// Module       : point.hpp
// Date         : 8/20/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a geometric point
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(POINT_HPP)
#define POINT_HPP

#include "gtypes.h"
#include <stdlib.h>
#include <math.h>
#include <iostream.h>
#include <iomanip>

class Point
{
private:
  GINT         gdim_;
  GDOUBLE      eps_;
  GDOUBLE      *px_[3];
public:
                  Point(); 
                  Point(GDOUBLE eps); 
                 ~Point();
  friend ostream& operator<<(ostream &, Point &);

  GDOUBLE      x1;
  GDOUBLE      x2;
  GDOUBLE      x3;

  inline GBOOL    operator==(Point &p) // Add 'fuzziness' to equality check
  { GINT  i, n; GBOOL b; GDOUBLE del;    
    // p.x_i = g * 2^n = g * 10^m, where m=n log_10(2):
    for ( i=0,b=TRUE;i<gdim_;i++) { frexp(p[i],&n); del=eps_*pow(10.0,0.301029995663981*n); // scale bracket to point
      b = b && ( p[i] >= *px_[i] - del && p[i] <= *px_[i] + del ); }             // do check for equality
    return b; }

  inline GBOOL    operator!=(Point &p) 
  { return !this->operator==(p); }

  inline void  operator=(Point &p)
  { eps_ = p.eps_; x1 = p.x1; x2 = p.x2; x3 = p.x3; }

  inline void  operator=(GDOUBLE f)
  { x1 = f;  x2 = f;  x3 = f; }

  inline GDOUBLE &operator()(GINT  i)
  { if ( i<0 || i>=3 ) { cout << "Point::(): access error; bad index:" << i << endl; exit(1); }
    return *px_[i]; }

  inline GDOUBLE &operator[](GINT  i)
  { if ( i<0 || i>=3 ) { cout << "Point::[]: access error; bad index:" << i << endl; exit(1); }
    return *px_[i]; }

  inline void Bracket(GDOUBLE e)
  { eps_ = e; }

  inline GDOUBLE GetBracket()
  { return eps_ ; }

  inline GDOUBLE GetDim()
  { return gdim_ ; }

  inline void Truncate()
  { GINT  i, n; GDOUBLE del, is;
    // p.x_i = g * 2^n = g * 10^m, where m=n log_10(2):
    for ( i=0;i<gdim_;i++ ) { frexp(*px_[i],&n); del=eps_*pow(10.0,0.30103*n); // scale bracket to point
      is = *px_[i]>0?1.0:-1.0; *px_[i] = *px_[i]!=0.0 ? is*(fabs(*px_[i])-del): 0.0;} }


};

#endif
