//************************************************************************************//
// Module       : schurlapop.hpp
// Date         : 7/16/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the Laplacian operator derived from the Schur 
//                complement decompoosition of the 
//                discrete form of the Stokes equations
//                where the pdV work term has a pressure residing 
//                on a different grid than the velocity, within
//                the same element. It is intended to act on the
//                p-quantity in the p Div v term. Its form is
//                  D1 M^-1 D1^T  + D2 M^-1 D2^T
//                where M is the mass matrix, and Di are the 
//                weak pdV derivative operators defined in StokesOp.
//                velem and pelem are the elements where the 
//                v-quantity  and p-quantity reside, respectively 
//                
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(SCHURLAPOP_HPP)
#define SCHURLAPOP_HPP

#include "linop.hpp"
#include "elem2d.hpp"
#include "massop.hpp"
#include "stokesop.hpp"

class SchurLapOp: public LinOp 
{
public:
                           SchurLapOp();
                           SchurLapOp(Elem2D *ve, Elem2D *pe);
//                         SchurLapOp(const SchurLapOp &);
                          ~SchurLapOp();

         GVector           operator*(GVector) ; // Multiply operator on the RHS by vector
         GVector          *GetMassMatrix();
         void              OpVec_prod(GVector &x, GVector &ret);
         void              SetConst(GDOUBLE c);
         void              SetElem(Elem2D *ve, Elem2D *pe);
         void              SetVBdyData(GINT idir, GVector *vbdy);
         void              DoCentralOp(GBOOL bop);
         GVector           *GetiMass();
         Elem2D            *GetElem();
#if 0
         Elem2D            *GetPElem();
#endif

//       friend ostream&   operator<<(ostream&, const SchurLapOp&);

private:
         GBOOL             QuadOp(GVector *x, GVector *newx);
         GBOOL             TriangleOp(GVector *x, GVector *newx);
         void              DeleteDynamic();
         void              Reset();
         void              Init(Elem2D *ve, Elem2D *pe);
  
         GBOOL            bCentralOp_;
         GDOUBLE          mConst;
         Elem2D           *velem;
         Elem2D           *pelem;
         GVector          *vtmpp0;
         GVector          *vtmpv0;
         GVector          *vtmpv1;
         GVector          *v1bdy;
         GVector          *v2bdy;
         GVector          *M;
         GVector          *iM;
         StokesOp         *pD1;
         StokesOp         *pD2;
         StokesOp         *pDT1;
         StokesOp         *pDT2;

};

#endif
