//************************************************************************************//
// Module       : pcblockjac_helm.hpp
// Date         : 7/17/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a block Jacobi preconditioner object to be used
//                for preconditioning the Helmholtz operator
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(PCBLOCKJAC_HELM_HPP)
#define PCBLOCKJAC_HELM_HPP 
#include "linop.hpp"
#include "helmholtzop.hpp"
#include "defquad2d.hpp"
#include "rectquad2d.hpp"
#include "diagop.hpp"

class PCBlockJac_Helm: public LinOp
{
public:
                           PCBlockJac_Helm();
                           PCBlockJac_Helm(LinOp *A);
                           PCBlockJac_Helm(Elem2D *e, HelmholtzOp *Hin=NULL);
//                         PCBlockJac_Helm(const PCBlockJac_Helm &);
                          ~PCBlockJac_Helm();

         GVector           operator*(GVector) ; // Multiply precond by right-vector
         void              OpVec_prod(GVector &q, GVector &ret);
         void              SetConst(GDOUBLE clc, GDOUBLE cmc);
         void              SetConst(GDOUBLE clc1, GDOUBLE clc2, GDOUBLE cmc);
         void              SetElem(Elem2D *e);
         void              SetHelm(HelmholtzOp *Hin);
         void              SetMask(GVector *m);


private:
         GBOOL             DefmQuadH();
         GBOOL             RectQuadH();
         GBOOL             TriangleH();
         GBOOL             ComputeOp();

         GINT              N_[GDIM];// 1, 2, 3--size 
         GINT              NN_;     // 1 X 2 X 3 - size 
         GBOOL             bDeletedHere_; 
         GDOUBLE           lc1_;    // Laplacian-multiplicative constant
         GDOUBLE           lc2_;    // Laplacian-multiplicative constant
         GDOUBLE           mc_;     // Mass matrix-multiplicative constant
         Elem2D           *elem_;
         GVector          *mask_;
         GVector           icol_;
         GVector           rcol_;
         GMatrix           H_;
         GMatrix           iH_;
         HelmholtzOp       *Hop_;


};

#endif
