//************************************************************************************//
// Module       : pcpointjac_helm.hpp
// Date         : 7/17/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a point Jacobi preconditioner object to be used
//                for preconditioning the Helmholtz operator
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(PCPOINTJAC_HELM_HPP)
#define PCPOINTJAC_HELM_HPP 
#include "linop.hpp"
#include "defquad2d.hpp"
#include "rectquad2d.hpp"
#include "diagop.hpp"

class PCPointJac_Helm: public LinOp
{
public:
                           PCPointJac_Helm();
                           PCPointJac_Helm(LinOp *A);
                           PCPointJac_Helm(Elem2D *e);
//                         PCPointJac_Helm(const PCPointJac_Helm &);
                          ~PCPointJac_Helm();

         GVector           operator*(GVector) ; // Multiply precond by right-vector
         void              OpVec_prod(GVector &q, GVector &ret);
         GVector          *SetConst(GDOUBLE clc, GDOUBLE cmc);
         GVector          *SetConst(GDOUBLE clc, GDOUBLE clc2, GDOUBLE cmc);
         GVector          *SetElem(Elem2D *e);
         GVector          *Invert();
         GVector          *GetDiag();
         GVector          *GetiDiag();

         Elem2D            *elem;


private:
         GBOOL             DefmQuadH();
         GBOOL             RectQuadH();
         GBOOL             TriangleH();
         GBOOL             ComputeOp();

         GINT              N1;     // 1-size
         GINT              N2;     // 2-size
         GINT              NN;     // 1 X 2 - size
         GDOUBLE             lc1;    // Laplacian-multiplicative constant
         GDOUBLE             lc2;    // Laplacian-multiplicative constant
         GDOUBLE             mc;     // Mass matrix-multiplicative constant
         GVector          *H;
         GVector          *iH;


};

#endif
