//************************************************************************************//
// Module       : gfieldlist.cpp
// Date         : 8/9/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple element linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast. 
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "gfieldlist.hpp"
#include "defquad2d.hpp"
#include "rectquad2d.hpp"
#include <typeinfo>

//************************************************************************************
//************************************************************************************
// Constructor Method
GFieldList::GFieldList(GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
iLevel_               (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{

} // end of constructor method


//************************************************************************************
//************************************************************************************
// Destructor
GFieldList::~GFieldList()
{
  empty();
}

//************************************************************************************
//************************************************************************************
// METHOD     : SetTimeLevel
// DESCRIPTION: 
// RETURNS    : Sets time level for operations on fields
//************************************************************************************
void GFieldList::SetTimeLevel(GINT ilevel)
{
  iLevel_ = ilevel;
} // end of method SetTimeLevel


//************************************************************************************
//************************************************************************************
// METHOD     : add (1)
// DESCRIPTION: 
// RETURNS    : add new structure to list; fill it with instantiated field object
//************************************************************************************
void GFieldList::add(const GINT  NTimeLevels, Elem2D *e, GSHORT ntmp)
{
  pCurr        = pEnd;
  pEnd         = new FieldListSt;
  pEnd->id     = nid;
  pEnd->cf     = TRUE;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  pEnd->member = new Field2D (NTimeLevels, e, ntmp);
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (1)


//************************************************************************************
//************************************************************************************
// METHOD     : add (2)
// DESCRIPTION: 
// RETURNS    : add new structure to list
//************************************************************************************
void GFieldList::add(Field2D *m)
{
  pCurr        = pEnd;
  pEnd         = new FieldListSt;
  pEnd->member = m ;
  pEnd->id     = nid;
  pEnd->cf     = FALSE;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
 
  // Set pointer to just-added structure:
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (2)


//************************************************************************************
//************************************************************************************
// METHOD     : del (1)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
Field2D *GFieldList::del(FieldListSt *e)
{
  Field2D     *m;
  FieldListSt *next, *prev;

  if ( e == NULL ) {
    cout << "Field2D *GFieldList::del (1) : attempting to delete a NULL list element" << endl;
    exit(1);
  }

  m    = e->member;
  prev = e->prev;
  next = e->next;

  if ( prev ) prev->next = next;
  if ( next ) next->prev = prev;

  if ( e->cf ) delete e->member;
  delete e;

//(pCurr ? pCurr->next : pStart) = pEnd;
//if ( pCurr  == e )  pCurr  = next ? next : pEnd;
//if ( pStart == e )  pStart = next ? next : pCurr;
  if ( pEnd   == e )  pEnd   = prev;
  if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pStart == e )  pStart = next;

  num--;

  if ( doRenumber ) renumber();

  return m;

} // end of method del (1)



//************************************************************************************
//************************************************************************************
// METHOD     : del (2)
// DESCRIPTION: delete structure from list
// RETURNS    : pointer to structure element deleted
//************************************************************************************
Field2D *GFieldList::del(Field2D *m)
{
  FieldListSt *e;

  if ( !(e=find(m)) ) return NULL;

  return del(e);

} // end of method del (2)


//************************************************************************************
//************************************************************************************
// METHOD     : del (3)
// DESCRIPTION: delete structure from list, indicated by element pointer
// RETURNS    : pointer to structure element deleted
//************************************************************************************
Field2D *GFieldList::del(Elem2D *e)
{
  FieldListSt *f=NULL;

  if ( !(f=find(e)) ) return NULL;

  return del(f);

} // end of method del (3)


//************************************************************************************
//************************************************************************************
// METHOD     : del (4)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
Field2D *GFieldList::del(GINT  id)
{ 
  FieldListSt *e;
  
  if ( !(e=find(id)) ) return NULL;

  return del(e);
 
} // end of method del (4)


//************************************************************************************
//************************************************************************************
// METHOD     : size
// DESCRIPTION:
// RETURNS    :  size of list
//************************************************************************************
GINT  GFieldList::size() const
{
  return num ;
} // end of method size

#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : start
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
 void GFieldList::start(FieldListSt *p = NULL)
{
  pCurr = ( p!=NULL ? p : pStart );
} // end of method start


//************************************************************************************
//************************************************************************************
// METHOD     : member (1)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
Field2D *GFieldList::member()
{
  return pCurr ? pCurr->member : NULL;

} // end of method member (1)


//************************************************************************************
//************************************************************************************
// METHOD     : member (2)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
Field2D *GFieldList::member(GINT  id)
{
  FieldListSt *e;

  if ( (e=find(id)) == NULL ) return NULL;

  return e->member;
} // end of method member (2)


//************************************************************************************
//************************************************************************************
// METHOD     : next
// DESCRIPTION: 
// RETURNS    :  
//************************************************************************************
FieldListSt *GFieldList::next()
{
  FieldListSt *p = pCurr ? pCurr->next : NULL;
  pCurr = p;
  return pCurr;
} // end of method next
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : curr
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
FieldListSt *GFieldList::curr()
{
  return pCurr;
} // end of method curr


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : find (1)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
FieldListSt *GFieldList::find(GINT  id)
{

  FieldListSt *p=pCurr;

  // check from current pointer first:
  if ( p && p->id == id ) return p;
  else if ( p && p->next && p->next->id == id ) {
    next();
    return p->next;
  }

  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL ) {
    if ( p->id == id ) return p;
    next();
  }
  return NULL;

} // end of method find (1)


//************************************************************************************
//************************************************************************************
// METHOD     : find (2)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
FieldListSt *GFieldList::find(Field2D *member)
{

  FieldListSt *p=pCurr;

  // check from current pointer first:
  if ( p && p->member == member ) return p;
  else if ( p && p->next && p->next->member == member ) { 
     next();
     return p->next;
  }

  // start at beginning and search:
  start();
  while ( (p=curr()) != NULL ) {
    if ( p->member == member ) return p;
    next();
  }
  return NULL;

} // end of method find (2)
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : find (3)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
FieldListSt *GFieldList::find(Elem2D *element)
{

  FieldListSt *p=pCurr;

  // check from current pointer first:
  if ( p && p->member && p->member->GetElement() == element ) return p;
  else if ( p && p->next && p->next->member && p->next->member->GetElement() == element ) {
     next();
     return p->next;
  }

  // start at beginning and search:
  start();
  while ( (p=curr()) != NULL ) {
    if ( p->member->GetElement() == element ) return p;
    next();
  }
  return NULL;

} // end of method find (3)



//************************************************************************************
//************************************************************************************
// METHOD     : operator() (1)
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
GDOUBLE &GFieldList::operator()(const GSHORT nLevel, const GINT iElem, const GINT i)
{
  Field2D *fld;

  if ( (fld=member(iElem)) == NULL ) {
    cout << "GFieldList::operator() (1): Cannot access element " << iElem << endl;
    exit(1);
  }

  
  return (*fld)(nLevel, i);

} // end of method operator() (1)


//************************************************************************************
//************************************************************************************
// METHOD     : operator() (2)
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
GDOUBLE &GFieldList::operator()(const GINT iElem, const GINT i)
{
  Field2D *fld;

  if ( (fld=member(iElem)) == NULL ) {
    cout << "GFieldList::operator() (2): Cannot access element " << iElem << endl;
    exit(1);
  }

 
  return (*fld)(0, i);

} // end of method operator () (2)


//************************************************************************************
//************************************************************************************
// METHOD     : X (1)
// DESCRIPTION: Get X-coordinate vector, for element iElem, specified by idir parameter
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
GVector *GFieldList::X(const GINT iElem, const GSHORT  idir)
{
  Field2D *fld;

  if ( (fld=member(iElem)) == NULL ) {
    cout << "GFieldList::X (1): Cannot access element " << iElem << endl;
    exit(1);
  }

  return fld->GetElement()->GetSpNodes(idir);

} // end of method X (1)



//************************************************************************************
//************************************************************************************
// METHOD     : X (2)
// DESCRIPTION: Get X-coordinate, for element iElem, specified by idir parameter,
//              at coord index i
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
GDOUBLE &GFieldList::X(const GINT iElem, const GSHORT  idir, const GINT i)
{
  Field2D *fld;

  if ( (fld=member(iElem)) == NULL ) {
    cout << "GFieldList::X (2): Cannot access element " << iElem << endl;
    exit(1);
  }

  return *(fld->GetElement()->GetSpNodes(idir)->Data()+i);

} // end of method X (2)


//************************************************************************************
//************************************************************************************
// METHOD     : dim
// DESCRIPTION: Get idir-dimension for element iElem
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
GINT  GFieldList::dim(const GINT iElem, const GSHORT  idir)
{
  Field2D *fld;

  if ( (fld=member(iElem)) == NULL ) {
    cout << "GFieldList::dim: Cannot access element " << iElem << endl;
    exit(1);
  }

  return fld->GetElement()->GetSpNodes(idir)->dim();

} // end of method dim


//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (1)
// DESCRIPTION:
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, GFieldList &a)
{

  GINT  i=0, j;

//if ( a == NULL ) return str;

  str << endl;
  a.start(NULL);
  while ( a.member() && i < a.size() ) {
     str << "member[" << i << "]:" << endl;
     for ( j=0; j<a.member()->GetNumTimeLevels(); j++ ) {
       str << "  field[level=" << j << "]=" << *(a.member()->GetExpCoeffs(j)) << endl;
     }
    a.next();
    i++;
  }
  a.start(NULL);

  return str;
} // end of << operator(1)


//************************************************************************************
//************************************************************************************
// METHOD     : renumber
// DESCRIPTION:
// RETURNS    : Renumber ids consecutively, used mainly after a delete
//************************************************************************************
GBOOL GFieldList::renumber()
{
  GINT      i=0;
  FieldListSt *p, *pkeep=curr();

  start(NULL);
  while ( (p=curr()) != NULL ) {
    p->id = i;
    next();
    i++;
  }
  nid = i;
  start(NULL);
  return TRUE;
} // end of method renumber


//************************************************************************************
//************************************************************************************
// Assignment operator = method (1) 
void GFieldList::operator=(GDOUBLE a)
{
  FieldListSt *p;

  start(NULL);
  while ( (p=curr()) != NULL ) {
    p->member->SetTimeLevel(iLevel_);
    *(p->member) = a;
    next();
  }
//start(pkeep);
} // end = operator (1)


//************************************************************************************
//************************************************************************************
// Assignment operator = method (2) 
void GFieldList::operator=(GFieldList &v)
{
  FieldListSt *p;

  start(NULL);
  v.start(NULL);
  while ( (p=curr()) != NULL ) {
    p->member->SetTimeLevel(iLevel_);
    *(p->member) = *(v.member());
    next();
    v.next();
  }
//start(pkeep);
} // end = operator (2)



//************************************************************************************
//************************************************************************************
// METHOD     : empty
// DESCRIPTION:
// RETURNS    : delete list data
//************************************************************************************
void GFieldList::empty()
{
  FieldListSt *dcurr, *dnext;

  dcurr = pStart;
  while ( dcurr ) {
    dnext = dcurr->next;
    del (dcurr);
    dcurr = dnext;
  }
  pStart = pEnd = pCurr = NULL;
  num = nid = 0;

} // end of method empty


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : operator() (1)
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
Field2D *&GFieldList::operator()(const GINT  iElem)
{
  FieldListSt *tt;

  if ( (tt=find(iElem)) == NULL ) {
    cout << "GFieldList::operator() (3): Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member ;

} // end of method operator ()  (1)


//************************************************************************************
//************************************************************************************
// METHOD     : operator[] (1)
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
Field2D *&GFieldList::operator[](const GINT  iElem)
{
  FieldListSt *tt;

  if ( (tt=find(iElem)) == NULL ) {
    cout << "GFieldList::operator[] (1): Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member ;

} // end of method operator []  (1)
#endif




