//************************************************************************************//
// Module       : glinoplist.cpp
// Date         : 7/17/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple LinOp linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast.
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "glinoplist.hpp"


//************************************************************************************
//************************************************************************************
// Constructor Method
GLinOpList::GLinOpList(GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{
} // end of constructor method


//************************************************************************************
//************************************************************************************
// Constructor Method (2)
GLinOpList::GLinOpList(GINT  nelems, GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{   
  GINT  i;

  for ( i=0; i<nelems; i++ ) {
    add(NULL,TRUE);
  }
    
} // end of constructor method (2)


//************************************************************************************
//************************************************************************************
// Destructor
GLinOpList::~GLinOpList()
{
  empty();
}


//************************************************************************************
//************************************************************************************
// METHOD     : add (1)
// DESCRIPTION: 
// RETURNS    : add new structure to list
//************************************************************************************
void GLinOpList::add(LinOp *m, GBOOL del_here)
{
  pCurr        = pEnd;
  pEnd         = new GLinOpElem;
  pEnd->member = m ;
  pEnd->id     = nid;
  pEnd->cf     = del_here;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (1)


//************************************************************************************
//************************************************************************************
// METHOD     : del (0)
// DESCRIPTION:
// RETURNS    : delete structure from list. Do a renumbering of ids if
//              set to do so on construction.
//************************************************************************************
LinOp *GLinOpList::del(GLinOpElem *e)
{
  LinOp      *m;
  GLinOpElem *next, *prev;

  if ( e == NULL ) {
    cout << "template<class TT> TT *GObjList<TT>::del (0) : attempting to delete a NULL list element" <<
endl;
    exit(1);
  }

  m    = e->member;
  prev = e->prev;
  next = e->next;

  if ( prev ) prev->next = next;
  if ( next ) next->prev = prev;

  if ( e->cf ) delete e->member;
  delete e;

//(pCurr ? pCurr->next : pStart) = pEnd;
//if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pEnd   == e )  pEnd   = prev;
  if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pStart == e )  pStart = next ? next : pCurr;

  num--;

  if ( doRenumber ) renumber();

  return m;

} // end of method del (0)



//************************************************************************************
//************************************************************************************
// METHOD     : del (1)
// DESCRIPTION:
// RETURNS    : delete structure from list. Do a renumbering of ids if 
//              set to do so on construction.
//************************************************************************************
LinOp *GLinOpList::del(LinOp *m)
{
  GLinOpElem *e;

  if ( !(e=find(m)) ) return NULL;

  return del(e);
  
} // end of method del (1)


//************************************************************************************
//************************************************************************************
// METHOD     : del (2)
// DESCRIPTION:
// RETURNS    : delete structure from list. Do a renumbering of ids if
//              set to do so on construction.
//************************************************************************************
LinOp *GLinOpList::del(GINT  id)
{ 
  GLinOpElem *e;
  
  if ( !(e=find(id)) ) return NULL;

  return del(e);
 
} // end of method del (2)


//************************************************************************************
//************************************************************************************
// METHOD     : size
// DESCRIPTION:
// RETURNS    :  size of list
//************************************************************************************
GINT  GLinOpList::size() 
{
  return num ;
} // end of method size


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : start
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
void GLinOpList::start(GLinOpElem *p)
{
  pCurr = ( p!=NULL ? p : pStart );
} // end of method start


//************************************************************************************
//************************************************************************************
// METHOD     : member (1)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
LinOp *GLinOpList::member()
{
  return pCurr ? pCurr->member : NULL;
} // end of method member (1)


//************************************************************************************
//************************************************************************************
// METHOD     : member (2)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
LinOp *GLinOpList::member(GINT  id)
{
  GLinOpElem *e;

  if ( (e=find(id)) == NULL ) return NULL;

  return e->member;
} // end of method member (2)


//************************************************************************************
//************************************************************************************
// METHOD     : next
// DESCRIPTION: 
// RETURNS    :  
//************************************************************************************
GLinOpElem *GLinOpList::next()
{
  GLinOpElem *p = pCurr ? pCurr->next : NULL;
  pCurr = p;
  return pCurr;
} // end of method next
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : curr
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
GLinOpElem *GLinOpList::curr()
{
  return pCurr;
} // end of method curr


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : find (1)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
GLinOpElem *GLinOpList::find(GINT  id)
{

  GLinOpElem *p=pCurr;

  // check from current pointer first:
  if ( p && p->id == id ) return p;
  else if ( p && p->next && p->next->id == id ) {
     next();
     return p->next;
  }

  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL )
  {
    if ( p->id == id ) return p;
    next();
  }
  return NULL;

} // end of method find (1)


//************************************************************************************
//************************************************************************************
// METHOD     : find (2)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
GLinOpElem *GLinOpList::find(LinOp *member)
{

  GLinOpElem *p=pCurr;

  // check from current pointer first:
  if ( p && p->member == member ) return p;
  else if ( p && p->next && p->next->member == member ) {
    next();
    return p->next;
  }

  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL )
  {
    if ( p->member == member ) return p;
    next();
  }
  return NULL;

} // end of method find (2)


//************************************************************************************
//************************************************************************************
// METHOD     : operator()
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
LinOp *&GLinOpList::operator()(const GINT  iElem)
{
  GLinOpElem  *tt;

  if ( (tt=find(iElem)) == NULL )
  {
    cout << "GTTList::operator(): Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member;

} // end of method operator ()


//************************************************************************************
//************************************************************************************
// METHOD     : operator[]
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
LinOp *&GLinOpList::operator[](const GINT  iElem)
{
  GLinOpElem  *tt;

  if ( (tt=find(iElem)) == NULL )
  {
    cout << "GTTList::operator[]: Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member;

} // end of method operator[]
#endif


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (1)
// DESCRIPTION:
// ARGUMENTS  :
//
// RETURNS    :  
//************************************************************************************
ostream &operator<<(ostream &str, GLinOpList &a)
{

  GINT  i=0;  

  str << endl;
  a.start(NULL);
  while ( a.member() && i < a.size() )
  {
    str << "member[" << i << "]=" << *(a.member()) << endl;
    a.next();
    i++;
  }
  a.start(NULL);
    
  return str;
} // end of << operator(1)
#endif
  

//************************************************************************************
//************************************************************************************
// METHOD     : renumber
// DESCRIPTION:
// RETURNS    : Renumber ids consecutively, used mainly after a delete
//************************************************************************************
GBOOL GLinOpList::renumber()
{
  GINT       i=0;
  GLinOpElem *p, *pkeep=curr();

  start(NULL);
  while ( (p=curr()) != NULL )
  {
    p->id = i;
    next();
    i++;
  }
  nid = i;
  start(NULL);
  return TRUE;
} // end of method renumber


//************************************************************************************
//************************************************************************************
// METHOD     : empty
// DESCRIPTION:
// RETURNS    : delete list data
//************************************************************************************
void GLinOpList::empty()
{
  GLinOpElem *dcurr, *dnext;

  dcurr = pStart;
  while ( dcurr )
  {
    dnext = dcurr->next;
    del (dcurr);
    dcurr = dnext;
  }
  pStart = pEnd = pCurr = NULL;
  num = nid = 0;

} // end of method empty


