//************************************************************************************//
// Module       : gobjbuffer.cpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a buffer template  object holding GASpAR objects
// Derived From :
// Modifications:
//************************************************************************************//
#include <memory.h>
#include "gobjbuffer.hpp"


//************************************************************************************
//************************************************************************************
// Constructor Method (1)
template<class TBUFF> GObjBuffer<TBUFF>::GObjBuffer<TBUFF>()
:
n                     (0),
data                  (NULL)
{
} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Constructor Method (2)
//************************************************************************************
template<class TBUFF> GObjBuffer<TBUFF>::GObjBuffer<TBUFF>(GINT  size)
:
n                     (MAX(size,0)),
data                  (NULL)
{
  if ( n > 0 ) {
    data = new TBUFF [n];
  }

} // end of constructor method (2)


//************************************************************************************
//************************************************************************************
// Copy constructor method
//************************************************************************************
template<class TBUFF> GObjBuffer<TBUFF>::GObjBuffer<TBUFF>(const GObjBuffer<TBUFF> &a)
{
#if 0
   GINT i;

   // copy member data:
   n    = a.n;
   if ( n > 0 ) data = new TBUFF [a.n];

   //  copy array data:
   for ( i=0; i<n; i++ ) data[i] = a.data[i];
#endif

} // end of copy constructor method


//************************************************************************************
//************************************************************************************
// Destructor
//************************************************************************************
template<class TBUFF> GObjBuffer<TBUFF>::~GObjBuffer<TBUFF>()
{
   DeleteDynamic();
}


#if 0
//************************************************************************************
//************************************************************************************
// Assignment operator method 
//************************************************************************************
template<class TBUFF> void GObjBuffer<TBUFF>::operator=(GObjBuffer<TBUFF> &a)
{
  GINT i;

  if ( this != &a ) 
  {
    if ( a.n == 0 || a.data == NULL ) return;
    if ( a.n != n ) 
    {
      cout << "GObjBuffer::=: incompatible assignment" << endl;
      return;
    }


    //  copy array data:
    for ( i=0; i<n; i++ ) data[i] = a.data[i];
  }

} // end = operator


//************************************************************************************
//************************************************************************************
// Assignment operator method
//************************************************************************************
template<class TBUFF> void GObjBuffer<TBUFF>::operator=(TBUFF  *a)
{
  GINT  i;

  if ( data == NULL && n > 0 )
  {
    cout << "GObjBuffer::=: illegal assignment" << endl;
    exit(1);
  }

  //  copy array data:
  for ( i=0; i<n; i++ )
  {
    data[i] = a;
  }

} // end = operator
#endif

//************************************************************************************
//************************************************************************************
// METHOD     : dim
// DESCRIPTION:
// RETURNS    :  size of vector
//************************************************************************************
template<class TBUFF> GINT  GObjBuffer<TBUFF>::dim() const
{
  return n ;
} // end of method dim


//************************************************************************************
//************************************************************************************
// METHOD     : Data
// DESCRIPTION: 
// RETURNS    :  pointer to the array data area
//************************************************************************************
template<class TBUFF> TBUFF *GObjBuffer<TBUFF>::Data()
{
  return data;
} // end of method Data


//************************************************************************************
//************************************************************************************
// METHOD     : Resize
// DESCRIPTION: resizes dynamically allocated quantities
//              if required
// RETURNS    :  TRUE on success, else FALSE
//************************************************************************************
template<class TBUFF> GBOOL GObjBuffer<TBUFF>::Resize(GINT  newSize)
{
  GINT  j;
  GBOOL bRet = FALSE;

  if ( newSize == n && n > 0 ) return TRUE;

  if ( data != NULL ) {
    delete [] data;
    data = NULL;
  }
  if ( newSize == 0 ) {
    n = newSize;
    return TRUE;
  }
  if ( newSize <  0 ) {
    cout << "GObjBuffer<TBUFF>::Resize: invalid dimension" << endl;
    exit(1);
  }
  
  data = new TBUFF [newSize];
  bRet = FALSE;
  if ( data != NULL ) {
    n = newSize;
    bRet = TRUE;
  }
  return bRet;

} // end of method Resize


//************************************************************************************
//************************************************************************************
// METHOD     : DeleteDynamic
// DESCRIPTION: deletes dynamically allocated quantities
// RETURNS    :  none
//************************************************************************************
template<class TBUFF> void GObjBuffer<TBUFF>::DeleteDynamic()
{

  if ( data != NULL ) delete [] data ;
  data = NULL;
  return;

} // end of method DeleteDynamic


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : operator <<
// DESCRIPTION: output buffer of <TBUFF>
// RETURNS    :
//************************************************************************************
template<class TBUFF> ostream &operator<<(ostream &str, GObjBuffer<TBUFF> &a)
{

  GINT  i;
  for ( i=0; i<a.dim(); i++ )
    str << (TBUFF*)a[i] << "  ";

  return str;
} // end of << operator <TBUFF>

#endif
