//************************************************************************************//
// Module       : gtbuffer.hpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a buffer template object  for objects that include nonstandard types, 
//                e.g., enumerated lists.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GTBUFFER_HPP)
#define GTBUFFER_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>

#if !defined(GNIDBuffer )
#  define GNIDBuffer  GBuffer<GNODEID>
#endif

#if !defined(GIBuffer )
#  define GIBuffer  GBuffer<GINT >
#endif

#if !defined(GLBuffer )
#  define GLBuffer  GBuffer<GLONG >
#endif

#if !defined(GWBuffer )
#  define GWBuffer  GBuffer<GWORD>
#endif

#if !defined(GDWBuffer )
#  define GDWBuffer  GBuffer<GDWORD>
#endif

#if !defined(GKEYBuffer)
#  define GKEYBuffer GBuffer<GKEY>
#endif

#if !defined(GSBuffer  )
#  define GSBuffer   GBuffer<GSHORT>
#endif

#if !defined(GUIBuffer)
#  define GUIBuffer GBuffer<GUSHORT>
#endif

#if !defined(GByteBuffer)
#  define GByteBuffer GBuffer<GBYTE>
#endif

#if !defined(GUCharBuffer)
#  define GUCharBuffer GBuffer<GUCHAR>
#endif

#if !defined(GDBuffer )
#  define GDBuffer  GBuffer<GDOUBLE>
#endif

#if !defined(GBTBUFFER)
#  define GBTBuffer  GBuffer<BDYTYPE>
#endif

#if !defined(GETBuffer )
#  define GETBuffer  GBuffer<ELEMTYPE>
#endif

#if !defined(GCHBuffer)
#  define GCHBuffer  GBuffer<GCHandle>
#endif


template<class TBUFF> class GBuffer
{


private:

// Private methods:
        void              DeleteDynamic();
        void              sift_down(const GINT l, const GINT r);

// Private data:
        GINT               n;
        TBUFF             *data;


public:
                           GBuffer();
                           GBuffer(GINT  size);
                           GBuffer(TBUFF *buffer, GINT  n);
                           GBuffer(const GBuffer &);
//virtual                 ~GBuffer();
                          ~GBuffer();


         void              operator=(GBuffer<TBUFF> &);
         void              operator=(TBUFF m);
inline    TBUFF            &operator()(const GINT  i) { 
#if defined(GARRAY_BOUNDS)
                            if ( i >= n || i < 0 ) {
                              cout << "GBuffer<T>::(): access error: index=" << i << "; max=" <<  n << endl;
                              exit(1);
                             }
#endif
                            return *(data+i); }
inline    TBUFF            &operator[](const GINT  i) const {
#if defined(GARRAY_BOUNDS)
                            if ( i >= n || i < 0 ) {
                              cout << "GBuffer<T>::[]: access error: index=" << i << "; max=" <<  n << endl;
while(1);
                              exit(1);
                             }
#endif
                            return *(data+i); } 

#if 1
#if defined (GBUFF_DEF_GINT )
         friend ostream&   operator<<(ostream &, GBuffer<GINT > &);
#endif
#if defined (GBUFF_DEF_GLONG)
         friend ostream&   operator<<(ostream &, GBuffer<GLONG> &);
#endif
#if defined (GBUFF_DEF_GDWORD)
         friend ostream&   operator<<(ostream &, GBuffer<GDWORD> &);
#endif
#if defined (GBUFF_DEF_GSHORT)
         friend ostream&   operator<<(ostream &, GBuffer<GSHORT>& );
#endif
#if defined (GBUFF_DEF_GUSHORT)
         friend ostream&   operator<<(ostream &, GBuffer<GUSHORT>& );
#endif
#if defined (GBUFF_DEF_BYTE)
         friend ostream&   operator<<(ostream &, GBuffer<GBYTE> &);
#endif
#if defined (GBUFF_DEF_GDOUBLE)
         friend ostream&   operator<<(ostream &, GBuffer<GDOUBLE>& );
#endif
#if defined (GBUFF_DEF_BDYTYPE)
         friend ostream&   operator<<(ostream &, GBuffer<BDYTYPE>& );
#endif
#if defined (GBUFF_DEF_ELEMTYPE)
         friend ostream&   operator<<(ostream &, GBuffer<ELEMTYPE>& );
#endif
#if defined (GBUFF_DEF_GKEY)
         friend ostream&   operator<<(ostream &, GBuffer<GKEY>& );
#endif
#if defined (GBUFF_DEF_GNODEID)
         friend ostream&   operator<<(ostream &, GBuffer<GNODEID>& );
#endif
#if defined (GBUFF_DEF_GCHANDLE)
         friend ostream&   operator<<(ostream &, GBuffer<GCHandle>& );
#endif
#else
         friend ostream&   operator<<(ostream &s, const GBuffer<TBUFF> &v);
#endif

    
                   
         GINT              dim() const ;
         TBUFF            *Data();
         GBOOL             Resize(GINT  order);
         GBOOL             contains(TBUFF imember, GINT  &index, TBUFF floor);
         GBOOL             contains(TBUFF imember, GINT  istart, GINT  num, GINT  &index, TBUFF floor);
         GBOOL             contains(GWORD imember, GINT  &index, GINT  ihilo, TBUFF floor);
         GBOOL             contains(TBUFF imember, GINT  &index);
         GBOOL             distinct(GINT  *&index, GINT  &n_distinct, TBUFF floor=-1);
         void              Set(const TBUFF);
         void              GetSection(GBuffer<TBUFF> &section, GINT  *ilist, GINT  nlist);
         GBuffer<TBUFF>   &GetSection(GINT  *ilist, GINT  nlist);
         void              sortlohi();
         void              sortincreasing();
         void              sortdecreasing();


};
#if defined(_LINUX) || defined(_AIX)
template class GBuffer<GDOUBLE>;
ostream &operator <<(ostream&, const GBuffer<GDOUBLE>&);
#if defined(GBUFF_DEF_GINT )
template class GBuffer<GINT >;
ostream &operator <<(ostream&, const GBuffer<GINT >&);
#endif
#if defined(GBUFF_DEF_GLONG )
template class GBuffer<GLONG >;
ostream &operator <<(ostream&, const GBuffer<GLONG>&);
#endif
#if defined(GBUFF_DEF_GDWORD) 
template class GBuffer<GDWORD>;
ostream &operator <<(ostream&, const GBuffer<GDWORD>&);
#endif
#if defined(GBUFF_DEF_GKEY) 
template class GBuffer<GKEY>;
ostream &operator <<(ostream&, const GBuffer<GKEY>&);
#endif
#if defined(GBUFF_DEF_GSHORT)
template class GBuffer<GSHORT>;
ostream &operator <<(ostream&, const GBuffer<GSHORT>&);
#endif
#if defined(GBUFF_DEF_GUSHORT)
template class GBuffer<GUSHORT>;
ostream &operator <<(ostream&, const GBuffer<GUSHORT>&);
#endif
#if defined (GBUFF_DEF_GSHORT)
template class GBuffer<GBYTE>;
ostream &operator <<(ostream&, const GBuffer<GBYTE>&);
#endif
#if defined (GBUFF_DEF_BDYTYPE)
template class GBuffer<BDYTYPE>;
ostream &operator <<(ostream&, const GBuffer<BDYTYPE>&);
#endif
#if defined (GBUFF_DEF_ELEMTYPE)
template class GBuffer<ELEMTYPE>;
ostream &operator <<(ostream&, const GBuffer<ELEMTYPE>&);
#endif
#if defined (GBUFF_DEF_GCHANDLE)
template class GBuffer<GCHandle>;
ostream &operator <<(ostream&, const GBuffer<GCHandle>&);
#endif
#if defined (GBUFF_DEF_UCHAR)
template class GBuffer<GUCHAR>;
ostream &operator <<(ostream&, const GBuffer<GUCHAR>&);
#endif
#if defined (GBUFF_DEF_GNODEID)
template class GBuffer<GNODEID>;
ostream &operator <<(ostream&, const GBuffer<GNODEID>&);
#endif
#endif
#endif
