//************************************************************************************//
// Module       : gttlist.hpp
// Date         : 8/9/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple templatelinked list of a template class.
//                This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast as a template
//                class.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GTTLIST_HPP)
#define GTTLIST_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "gtbuffer.hpp"
#include "gtvector.hpp"


#if !defined(FBuffList)
#  define FBuffList GTTList<GDOUBLE,GBuffer>
#endif

#if !defined(IBuffList)
#  define IBuffList GTTList<GINT ,GBuffer>
#endif

#if !defined(BTBuffList)
#  define BTBuffList GTTList<BDYTYPE,GBuffer>
#endif

#if !defined(GVecList)
#  define GVecList GTTList<GDOUBLE,GTVector>
#endif


#if !defined(TTLINKELEM)
#define TTLINKELEM
#define TTLinkElem LinkElemTT<TL,TT>
template<class TL, template<class> class TT> class LinkElemTT {
public:
GINT       id;
GBOOL      cf;
TT<TL>     *member;
TTLinkElem *next;
TTLinkElem *prev;
}; 
#endif

template<class TL, template<class> class TT> class GTTList
{
public:
                          GTTList(GBOOL renumber_on_delete=FALSE);
                          GTTList(GINT  nelems, GBOOL renumber_on_delete=FALSE);
                          GTTList(const GTTList &){};
                         ~GTTList();

         void             operator=(TL a);
         void             operator=(GTTList<TL,TT> &v);
         void             add();
         void             add(TT<TL> *c, GBOOL delete_here);
         void             add(TL *c, GINT  n, GBOOL delete_here);
         TT<TL>           *del(TTLinkElem *e);
         TT<TL>           *del(TT<TL> *c);
         TT<TL>           *del(GINT  id);
         void             start(TTLinkElem *p=NULL);
         GINT             size() ;
         TT<TL>           *member();
         TT<TL>           *member(GINT id);
         TTLinkElem       *next();
         TTLinkElem       *curr();
         TTLinkElem       *find(GINT  id);
         TTLinkElem       *find(TT<TL> *);
         TL               &operator()(const GINT iElem, const GINT i);
         TT<TL>           *&operator()(const GINT iElem);
         TT<TL>           *&operator[](const GINT iElem);
         GINT             dim(const GINT iElem);
         GBOOL            renumber();
         void             empty();
         friend ostream&  operator<<(ostream&, GTTList<GDOUBLE,GBuffer>&);
         friend ostream&  operator<<(ostream&, GTTList<GINT ,GBuffer>&);
         friend ostream&  operator<<(ostream&, GTTList<BDYTYPE,GBuffer>&);
         friend ostream&  operator<<(ostream&, GTTList<GDOUBLE  ,GTVector>&);
#if 0
         friend ostream&  operator<<(ostream&, GTTList<TL,TT>&);
#endif

private:
// Private methods:

// Private data:
        GINT              nid;
        GINT              num;
        GBOOL             doRenumber;
        TTLinkElem        *pStart;
        TTLinkElem        *pCurr;
        TTLinkElem        *pEnd;

};
#  if defined(_LINUX) || defined(_AIX)
template class GTTList<GDOUBLE,GBuffer>;
template class GTTList<GINT ,GBuffer>;
template class GTTList<BDYTYPE,GBuffer>;
template class GTTList<GDOUBLE,GTVector>;
ostream &operator <<(ostream&, GTTList<GDOUBLE,GBuffer>&);
ostream &operator <<(ostream&, GTTList<GINT ,GBuffer>&);
ostream &operator <<(ostream&, GTTList<BDYTYPE,GBuffer>&);
ostream &operator <<(ostream&, GTTList<GDOUBLE,GTVector>&);
# endif
#  if 0
GTTList<GDOUBLE,GBuffer>   __dec_SEFBList;
GTTList<GINT ,GBuffer>   __dec_SEIList;
GTTList<BDYTYPE,GBuffer> __dec_SEBTList;
GTTList<GDOUBLE,GTVector>   __dec_GVecList;
ostream &operator <<(ostream&, GTTList<GDOUBLE,GBuffer>&);
ostream &operator <<(ostream&, GTTList<GINT ,GBuffer>&);
ostream &operator <<(ostream&, GTTList<BDYTYPE,GBuffer>&);
ostream &operator <<(ostream&, GTTList<GDOUBLE,GTVector>&);
#  endif
#endif

