//************************************************************************************
// Module       : gutils.hpp
// Date         : 2003/10/08 (AF)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Namespace encapsulating miscellaneous C-style utilities
//************************************************************************************

#if !defined(GUTILS_HPP)
#define GUTILS_HPP

#include "gtypes.h"
#include "gllbasis.hpp"
#include "gelemlist.hpp"
#include "gttlist.hpp"
#include "gtlist.hpp"
#include "gtbasislist.hpp"
#include "mesh_reader.hpp"
#include "ntree_adapt.hpp"
#include "morton_keygen.hpp"
#include "gbin_reader.hpp"

extern GBOOL bLocal_;

namespace GUtils {

GBOOL     InitMesh(char *fnmesh, GSHORT  rank_, GTBasisListGLL &gllpool, 
                   GElemList &gelems, GINT  &gnelems, GNIDBuffer  *&vnode_ids, GNODEID &vmaxid,
                   Point *&gd, GINT  &ngd, GINT ntmp, GINT  nadapt);
GBOOL     InitPMesh2d(GINT Nx, GINT Ny, GINT xNx, GINT xNy,
                      GTBasisListGLL &gllpool,
                      GElemList &gelems, GINT  &gnelems_, GNIDBuffer *&vnode_ids,
                      GNODEID &vmaxid, Point *&gd, GINT  &ngd, GINT ntmp, GINT  nadapt);

GKEY      RootID(GINT  i_tree, GINT  max_levels);
GBOOL     in_neighborlist(GNeighborList &elist, GSHORT  iproc, GINT  ielem, GINT  compid);
GDOUBLE   ComputeGlobalArea(GElemList &gelems);
GDOUBLE   ComputeGlobalIntegralV(GVecList   &uv, GElemList &gelems);
GDOUBLE   ComputeGlobalIntegralF(GFieldList &uf, GElemList &gelems);
void      ComputeGlobalDOFs(GElemList &gelems, GINT  &gndof, GDOUBLE &minLen, GDOUBLE &maxLen);
void      GetGlobalPeriodicity(GIBuffer &giPeriodic, Point *&gd, GINT nvert, GElemList &elems);
void      GetLoadStatistics(GDBuffer &gWork, GDOUBLE &favg, GElemList &gelems);

GDOUBLE   ComputeMinLength(GElemList &gelems);
GBOOL     DoDotProducts(GElemList &gelems, GVecList &a1, GVecList a2Vec[],
                        GDOUBLE lProds[], GDOUBLE prods[], const GINT  n_prods);
GBOOL     ComputeMasks(GElemList &gelems, NTreeAdapt *gsop, GCHandle hDSOp, GVecList &ub);
GBOOL     ComputeGMass(GElemList &gelems, NTreeAdapt *gsop, GCHandle hDSOp, GVecList &ub);
GBOOL     ComputeGOp  (GElemList &gelems, NTreeAdapt *gsop, GCHandle hDSOp, GVecList &opvec, GVecList &ub);

GBOOL     ComputeGDiag(GVecList &vlist, GElemList &gelems, NTreeAdapt *gsop, 
                       GCHandle hDSOp, GVecList &ub);
GDOUBLE   ComputeMaxDerivA(GElemList &gelems, GFieldList &field, GINT  idir);
GDOUBLE   ComputeL2Norm   (GVecList   &q, GElemList &gelems);
GDOUBLE   ComputeInfNorm  (GVecList   &q, GElemList &gelems);
GDOUBLE   ComputeEucNorm  (GVecList   &q, GElemList &gelems);
GDOUBLE   ComputeL2Norm   (GFieldList &q, GINT ilev=0);
GDOUBLE   ComputeInfNorm  (GFieldList &q, GINT ilev=0);
GDOUBLE   ComputeEucNorm  (GFieldList &q, GINT ilev=0);

GBOOL     Smooth      (GVecList &ub, GElemList &gelems, NTreeAdapt *gsop, GCHandle hDSOp); 

GBOOL     H1_Project (GVecList &ub, GElemList &gelems, NTreeAdapt *gsop, GCHandle hDSOp); 
//GBOOL     H1_Project (GFieldList &ub, NTreeAdapt *gsop, GCHandle hDSOp); 
GBOOL     H1_ProjectM(GVecList &ub, GElemList &gelems, NTreeAdapt *gsop, GCHandle hDSOp); 
//GBOOL   H1_ProjectC(GVecList &ub, GElemList &gelems, NTreeAdapt *gsop, GCHandle hDSOp); 


GBOOL     SetMorton(Morton_KeyGen *keygen_, GElemList *gelems_,
            Point *p_origin_, Point *dX_, Point *globdomain_, GINT  ng, GINT  max_levels_);
GBOOL     PointOnSeg(Point &P0, Point &P1, Point &r);
GBOOL     isPGlobalBdyElem(GIBuffer  &iGlobalFace, GIBuffer  &iElemFace, GINT  &nBdy,
                           Elem2D *elem, Point pGlobalDomain[], GINT  nGlobalDomain);
GBOOL     GetGBinVarV(GVecList &var, char *vlabel, GBinReader &rgbin);
GBOOL     GetGBinVarF(GFieldList &var, char *vlabel, GINT ilevel, GINT nlevels,
                      GINT ntmp, GElemList &gelems, GBinReader &rgbin);
void      RankIJ(GINT &I, GINT &J, GINT Nx, GINT Ny, GSHORT irank);
void      DoLocal(GBOOL blocal);
GDOUBLE   Rand        ();
void      TSeedRand   ();
GBOOL     SmoothPGrid(GVecList &pp, GVecList &utmp, GElemList &uelems,
                      GElemList &pelems, NTreeAdapt *gsop);
GBOOL     InterpLL(GVecList &pto, GElemList &gto, GVecList   &pfrom, GElemList &gfrom);
GBOOL     InterpFL(GVecList &pto, GElemList &gto, GFieldList &pfrom, GElemList &gfrom);





}
#endif // !defined(CUTILS_HPP)
