//************************************************************************************//
// Module       : siforcelist.hpp
// Date         : 5/9/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a linked list for state-independent (SIForce-based)
//                forces. It was taken largely from Algorithms and Data Structures 
//                in C++ by Ameraal, although it has been modified significantly. 
//
//                NOTE: it is clear that this class and the GFieldList template
//                can be derived from a common base class. The GElemList may also
//                be recast in this way, but there is some ambiguity because
//                the Elem is also a base class itself, and the syntax may
//                cause difficulty on some OS's.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(SIFORCELIST_HPP)
#define SIFORCELIST_HPP

#include "gtypes.h"
#include "siforce.hpp"
#include <iostream.h>
#include <stdlib.h>

#if !defined(SIFORCELIST_MEM)
#define SIFORCELIST_MEM
struct SIForceListSt {
GINT           id;       // Key id
GBOOL          cf;       // Was member fully instantiated?
SIForce        *member;  // Member data
SI_FORCE_TYPE  type;     // Element type id
SIForceListSt  *next;    // Next in list
SIForceListSt  *prev;    // Previous in list
}; 
#endif



class SIForceList
{

public:
                          SIForceList();
                          SIForceList(const SIForceList &);
                         ~SIForceList();

         void             add(SIForce *c, GBOOL delete_here=FALSE);
         SIForce          *del(SIForceListSt *c);
         SIForce          *del(SIForce *c);
         SIForce          *del(GINT  id);
inline   void             start(SIForceListSt *p=NULL) {
           pCurr = ( p!=NULL ? p : pStart );
         }
         GINT             size() const;
inline   SIForce          *member() {
           SIForceListSt *e;
           e = pCurr ? pCurr : pEnd;
           if ( e == NULL ) return NULL;
           return e->member;
         }
inline   SIForce          *member(GINT  id) {
           SIForceListSt *e;
           if ( (e=find(id)) == NULL ) return NULL;
           return e->member;
         }
inline   SIForceListSt    *next() {
           SIForceListSt *p = pCurr;
           if ( pCurr != NULL ) p = pCurr->next;
           pCurr = p;
           return pCurr;
         }
         SIForceListSt    *curr();
inline   SIForceListSt    *find(GINT  id) {
           SIForceListSt *p=pCurr;
           // check from current pointer first:
           if ( p && p->id == id ) return p;
           else if ( p && p->next && p->next->id == id ) {
             next();
             return p->next;
           }
           start(NULL); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->id == id ) return p;
             next();
           }
           return NULL;
         }
inline   SIForceListSt    *find(SIForce *member) {
           SIForceListSt *p=pCurr;
           // check from current pointer first:
           if ( p && p->member == member ) return p;
           else if ( p && p->next && p->next->member == member ) {
              next();
              return p->next;
           }
           start(NULL); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->member == member ) return p;
             next();
           }
           return NULL;
         }
inline   SIForce          *operator()(const GINT  iElem) {
           SIForceListSt *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else

           if ( (tt=find(iElem)) == NULL || tt->member == NULL ) {
             cout << "SIForceList::operator(): Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member;
         }
inline   SIForce          *operator[](const GINT  iElem) {
           SIForceListSt *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL || tt->member == NULL ) {
             cout << "SIForceList::operator[]: Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member;
         }
         GBOOL            renumber();
         void             empty();

// Private data:
        GINT               nid;
        GINT               num;
        SIForceListSt      *pStart;
        SIForceListSt      *pCurr;
        SIForceListSt      *pEnd;
};
#endif

