\name{print.lle}
\alias{print.lle}
\title{
  Prints  summary statistics of  local Lyapunov exponents 
}
\description{
Reports summary statistics for the distribution of 
local lyapunov exponents for different product lengths. 
}
\usage{
print.lle(obj, digits=5 , type="qr")
}
\arguments{
\item{obj}{
An object from the lle function. 
}
\item{digits}{
Number of significant digits in summary.
}
\item{type}{
Type of LLE estimate. Choices are "qr", "svd", "11". See the help file for 
lle for more details on these estimates. 
}

}
\value{
A matrix with the statistics as columns and the rows are different product 
lengths. 
}
\seealso{
make.lle, lle
}
\examples{
 make.lags(rossler.state[1:200,1],c(1,2,3)) -> data
# create 3-d time delay vector model of the x variable of rossler system.
 nnreg(data$x,data$y,5,5) -> rossler.fit

lle(predict( rossler.fit,derivative=1)) -> rossler.lle  # LLEs of Rossler data 

print(rossler.lle)  # plot LLEs 
# or just
rossler.lle

}
\keyword{ts}
% docclass is function
% Converted by Sd2Rd version 1.21.
