\name{make.lags}
\alias{make.lags}
\title{
  Lags vectors and covariates for fitting  an 
autoregressive model.
}
\description{Lags a set of vectors and covariates and produces a matrix 
that can be used for fitting an autoregressive model. This function also 
includes the lag information in the  returned object.}

\usage{
make.lags(x, lags, cov,nobs=3500)
}
\arguments{
\item{x}{
Vector or matrix representing a univariate or multivariate time series. 
(rows are assumed to index time) 
}
\item{lags}{
Vector of time delays used in reconstruction. 
}
\item{nobs}{
Maximum length of time series. 
}
\item{cov}{
A vector or matrix of covariates that will be matched with the times for  
the independent variable 
}
}
\value{

\item{x}{
Matrix of lagged values of the time series, independent variables. 
The covariates are the last columns of this matrix 
}
\item{y}{
Vector of time series values, dependent variables. 
}
\item{nvar}{
Number of variables or dimension of x matrix. 
}
\item{lags}{
Time delays used in constructing the x matrix. 
}
\item{start}{
Observation number of univariate time series used for the start of the  
y vector. 
}
\item{end }{
Observation number of univariate time series used for the end of the  
y vector.  
}
\item{skip}{
Information about which columns of the returned X matrix are covariates. 
}
}
\details{
This function is used to create the appropriate data structure for 
a nonlinear autoregressive process of the form X.t = F(X.t-1) + e.t. 
}
\seealso{
nnreg, rossler  
}
\examples{
make.lags(rossler.state[,1],c(1,2,3)) -> data   

}
\keyword{misc}
% docclass is function
% Converted by Sd2Rd version 1.21.
