       subroutine nnreg(
     * nmaxa, ntemp,xtemp, ytemp, 
     * inputi, inputr,
     * strt,nr,outputr,ni, outputi, ierr)
c
c 
       implicit double precision(a-h,o-z)
       parameter(kmax=8,jdmax=16)
       parameter(npmax=1+kmax*(jdmax+2), nxmax=50000)
       dimension xtemp(nmaxa,1), ytemp(nmaxa)
       integer inputi(20), offr 
       double precision inputr(20)
       dimension strt(1)
       double precision outputr(nr)
       integer ni
       integer outputi(ni)
       integer ierr, verbose
c
c 
       dimension ydat(nxmax),xmat(nxmax,jdmax),
     *   theta(npmax),ctheta(npmax),
     *   tsav(200,npmax),rsav(200),
     *  yhat(nxmax)
        dimension h0(npmax,npmax), xsd(jdmax), xmean(jdmax)
        data  glow, ghigh, scale / -1.26, 1.26, 0.5 /
        data  cgcv2, maxstep1, maxstep2 / 2.0, 50, 250 /
        data  ibrent, fltol / 0, 0.0 /   
        common /size/ k,jd,nx,m,jforce
        common /xdata/ ydat,xmat
        external objfun
        cgcv=1.0
c use initial value of ierr ( default = 0) as siwithc for verbose option
        if( ierr.gt.0) then
            verbose=1
         else
           verbose=0
        endif
        ierr=0

c----------- Data statement initializes many parameters
c----------- GCV cost=2, ibrent and fltol=0 so never used 
        if(verbose.gt.0) then
            write( *,*) " input integers"
            write( *,*) (inputi(kk), kk=1,12)
            write( *,*) " input reals"
            write( *,*)  ( inputr(kk), kk=1,2)
        endif

c----------- Set initial Jacobian to identity matrix

	call setidmat(h0,npmax)

c
 
c----------- Set parameters and minimization routine options
         nx    = inputi(1)
         nxc   = inputi(2)
        ngrid  = inputi(3)
        ntries = inputi(4)
        npol   = inputi(5)
        iprout = inputi(6)
        igreed = inputi(7)
c
        ftol1  = inputr(1)
        ftol2  = inputr(2)
c
        iseed  = inputi(8)
        itmax1 = inputi(9)
        itmax2 = inputi(10)

        iprint=itmax1+itmax2

         k1    = inputi(11)
         k2    = inputi(12)

c************ end of reading input 

        if( (nx.gt.nxmax).or.(nxc.gt.jdmax)) then
          write(*,*) "ERROR dataset too large!, nxmax = ",
     *         nxmax," jdmax = ",jdmax
          write(*,*) "Your data is        nx    = ",nx," nxc = ",nxc
          ierr=1
          return
        endif

c----------- if ngrid is negative set switch to read in start values
        if( ngrid.lt.0) then
          istart=1
          npol=1
          ntries=1
          ngrid=1
        else
           istart=0
        endif
c------ check for some bad choices of optimization parameters
        if( (npol.gt.200).or.(npol.gt.ngrid)) then
          write(*,*)"ERROR too many values to polish"
          ierr=1
          return
               endif
         if( (igreed.gt.0) .and.(iprout.gt.0)) then
           write(*,*) "ERROR Greedy algorithm can only output" 
           write(*,*) "the best fit, not all the polished results"
           ierr=1
           return
          endif

c---------- calculate if nr, the storage for outputr is large enough

          if( iprout.eq.0) then
              noutp=1
          else
              noutp=npol 
          endif

        ncheck = 0
           do kk = k1, k2
c
c if greedy alogrithm only single units added for each fit after the first 
c  k1
             if(( kk.ne.k1).and.( igreed.ne.0)) then
              hold= 3 + 2*nxc + 2 +  (nxc+2) +1
             else
               hold= 3 + 2*nxc + 2 +  kk*(nxc+2) +1
             endif
              ncheck = ncheck +hold*noutp 
           enddo


         if( verbose.gt.0) then
              write(*,*) "size of outputr is", nr, 
     &                      " to check, should be >=", ncheck
         endif

         if( nr.lt.ncheck) then 
           write(*,*) "ERROR Not enough storage for output array"
           write(*,*) "size of outputr is", nr, "should be >=", ncheck
           ierr=1
           return
         endif
c
            
c--------- check storage for model parameters
        if( ( 1+ (nxc+2)*k2).gt.npmax) then 
          write(*,*) "ERROR too many parameters" 
            write(*,*) "in the model for array size"
          ierr=1
           return
          endif

        if( ( k1.gt.kmax).or.( k2.gt.kmax)) then
         write(*,*) " ERROR too many hidden units"
        ierr=1
        return
        endif
          m= nx
          jd=nxc

c----------- Initialize random number generator
	iseed=abs(mod(iseed,125000)) 
        rn= RNG(0)
        rn=RNG(iseed)
        if(verbose.gt.0) then
              write(*,*) "current seed and first random deviate", 
     &           iseed, rn
        endif


c----------- copy data series into xdat; set nx=total series length
c----------- this is done so common block storage /xdata/ can be 
c----------  declared in this subroutine
        do j1= 1,nxc
          do j2 = 1, nx
            xmat(j2,j1)= xtemp(j2,j1)
          enddo
        enddo
        do j1 = 1, nx
            ydat(j1)= ytemp(j1)
        enddo

        if( verbose.gt.0) then           
         write(*,*) "# first row of data X, Y:"
         write(*,*) "#",(xmat(1,k), k=1,nxc), ydat(1)	
         write(*,*) "#"," last row of data X, Y:"
         write(*,*) "#",(xmat(nx,k), k=1,nxc), ydat( nx)	
         write(*,*) "# number of observations:", nx
         write(*,*) "# number of columns of X", nxc
         if( istart.eq.0) then
          write(*,*) "# number of points for grid search", ngrid
          write(*,*)"#",  glow, ghigh, ngrid 
         else
         write(*,*)"# starting values read in "
         write(*,*)"# a grid search has been omitted !"
        endif
        if( igreed.gt.0) then
         write(*,*) "# greedy algorithm used to fit net"
         write(*,*) "# in steps of ", igreed
        endif
        write( *,*) 
     &  "NOTE: summaries are with respect to standardized data"
        write(*,*) "# d  k   RMS        BIC      GCV    par    iter"
        endif
c------------ Standardize values to predict: SD=1, mean=0 
              do 500 ic=1,nxc
                 call sdev(xmat(1,ic),1,nx,tempsd, tempm)
                  xmean(ic)=tempm
                  xsd(ic)=tempsd
                 do 501 jj=1,nx
                        xmat(jj,ic)= (xmat(jj,ic)-tempm)/tempsd
  501            continue
  500         continue
                 
                 call sdev(ydat,1,nx,ysd, ymean)
                 do 502 jj=1,nx
                    ydat(jj) = (ydat(jj)-ymean)/ysd
  502            continue

c----------  set begining pointer to output array
             offr= 0        
c----------- beginning of output for S function

c----------- START LOOP on # units
        do 1004 ik=k1,k2
           k=ik
c----- reset number of hidden units to one for the greedy algorithm
           if( (igreed.gt.0).and.( ik.gt.k1)) then
                k=igreed
           endif
c----------- compute number of parameters

          npar=1+k*(jd+2+2*jforce)
          if (2*npar.gt.m) goto 1004
          if (npar.gt.npmax) goto 1004

c----------- if istart=1 then read in start values 
          if( istart.eq.1) then
              do jpar=1, npar
               tsav(1,jpar)= strt(jpar)
              enddo
          endif
          do 15 i=1,200
              rsav(i)=10000.
15        continue
      

c----------- START LOOP on repeated fits

c----------- if start=0 then do random search for starting values

           if( istart.eq.0) then 

c----------- to match lenns glow= -1.26 ghigh =1.26 ngrid = 256
            step = (ghigh- glow)/(ngrid-1)
            do 99 irep=1,ngrid

c----------- initialize parameter choices
             eps=scale*10**( step*irep + glow )

             call tinit(theta,npar,eps,ntries)

             if( (verbose.gt.1).and.(irep.eq.ngrid)) then 
               write(*,*) " theta from initial fit last grid box", 
     &            (theta(kk), kk=1,npar)
              endif

c----------- do a high-tolerance fit
              call bfgsfm(objfun,npar,npmax,theta,h0,ftol1,fltol,
     &              itmax1,maxstep1,fnew,iter,iprint,inform,ibrent)

               xm=float(m)
              bic=fnew*sqrt( 1.0+npar*log(xm)/(xm-npar) )


c  fnew=rms error; xm = sample size ( dim(X)[1] ) ;
c This is actually the sqrt of what is usually called BIC.


                imax=idamax(npol,rsav,1)
                rmax=rsav(imax)
                if( (fnew.lt.rmax) ) then 

                if(verbose.gt.1) then
                   write(*,*) "saved fnew",imax, fnew
                endif

                rsav(imax)=fnew
                do 85 jpar=1,npar
                   tsav(imax,jpar)=theta(jpar)
85              continue

9000            format( 5e16.8)
           
             endif
99        continue
        endif               
c----------- END LOOP on repeated fits
          do 999 i=1,npol
            do 997 jpar=1,npar
                    theta(jpar)=tsav(i,jpar)
997         continue

c----- entering subroutine theta are starting values from grinding

            if( verbose.gt.1) then
            write(*,*) "npol start ", i, (theta(kk), kk=1,npar) 
            endif

            call bfgsfm(objfun,npar,npmax,theta,h0,ftol2,fltol,
     &               itmax2,maxstep2,fnew,iter,iprint,inform,ibrent)
c----------- convert the parameters to canonical form to avoid 
c----------- identification problems

            call canpar(theta,k, nxc, ctheta)

            if( verbose.gt.1) then
            write(*,*) "after bfgsfm", i, (theta(kk), kk=1,npar) 
            endif

c----------- save new parameter estimates. 
            do 998 jpar=1,npar
                    tsav(i,jpar)= ctheta(jpar)
998         continue

        
               xm=float(m)
              bic=fnew*sqrt( 1.0+npar*log(xm)/(xm-npar) )
             
c  fnew=rms error; xm = sample size ( dim(X)[1] ) ;
c This is actually the sqrt of what is usually called BIC.


		gcv=(fnew/(1.-(cgcv*float(npar)/xm)))**2
               if( (fnew.lt.ftest).or.(i.eq.1)) then 
                      ibest=i
                      ftest=fnew
                endif

c-------- save all polished values to output array 
           if( iprout.gt.0) then
             outputr(offr+1)=  nxc
             outputr(offr+2)= k
             outputr(offr+3)=fnew
             offr= offr +3
             do jj=1, nxc
              outputr(offr+jj)= xmean(jj)
             enddo
             offr= offr + nxc
             do jj=1, nxc
              outputr(offr+jj)= xsd(jj)
             enddo
             offr= offr + nxc
             outputr(offr+1)=  ymean
             outputr(offr+2)=  ysd
             offr= offr + 2
              do jj=1, npar
              outputr(offr+jj)= ctheta(jj)
             enddo
             offr = offr + npar
c---------- end save of output array
           endif 
c
c
           if( verbose.gt.0) then    
                write(*,98) jd,k,fnew,bic,gcv,npar,iter,
     *                       inform
           endif
98          format(1x,2i3,2x,f9.6,2(2x,f7.4),i3,i7,i3,2(2x,f7.3))
         
999         continue
            
            do 1002 jpar=1,npar
                    ctheta(jpar)=tsav(ibest,jpar)
1002         continue

c-----  with smallest rms out of polished results

c-------- save final best fit to output array 
            if( iprout.eq.0) then
             outputr(offr+1)=  nxc
             outputr(offr+2)= k
             outputr(offr+3)=fnew
             offr= offr +3
             do jj=1, nxc
              outputr(offr+jj)= xmean(jj)
             enddo
             offr= offr + nxc
             do jj=1, nxc
              outputr(offr+jj)= xsd(jj)
             enddo
             offr= offr + nxc
             outputr(offr+1)=  ymean
             outputr(offr+2)=  ysd
             offr= offr + 2
              do jj=1, npar
              outputr(offr+jj)= ctheta(jj)
             enddo
             offr = offr + npar
c---------- end save of output array

            endif
            
c----- calculate residual vector and substitute for y if this
c----- is the greedy algorithm
            if( igreed.gt.0) then
            call netev( npar,ctheta,k,xmat, nxmax, nx,nxc,yhat)
            do 9100 jj=1,nx
c----- find residuals on raw scale 
              ydat(jj)= (ydat(jj)- yhat(jj))*ysd
 9100       continue
c----- reset the scale for next fit  
                 call sdev(ydat,1,nx,ysd, ymean)
                 do 9200 jj=1,nx
                    ydat(jj) = (ydat(jj)-ymean)/ysd
 9200            continue

           endif            

 1004    continue
c----------- END LOOP on #units
C this is the number of elements in outputr
       outputi(1)= offr


       return
       end










