### Name: predict.Krig
### Title: Evaluation of Krig spatial process estimate.
### Aliases: predict.Krig
### Keywords: spatial

### ** Examples

Krig(ozone$x,ozone$y, theta=50) ->fit
predict( fit) # gives predicted values at data points

# only the fixed part of the model

predict( fit, just.fixed=TRUE) 

# in this case the default is a linear spatial drift  (m=2) and there 
# are no additional covariates

grid<- make.surface.grid( list( seq( -40,40,,15), seq( -40,40,,15)))

look<- predict(fit,grid) # evaluate on a grid of points

# some useful graphing functions
out.p<- as.surface( grid, look) # reformat into $x $y $z image-type object
contour( out.p)  

# refit with 10 degrees of freedom in surface

look<- predict(fit,grid, df=15)

# refit with random data 

look<- predict( fit, grid, y= rnorm( 20))




